// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/volume.h>
#include <giomm/private/volume_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <glibmm/error.h>
#include <glibmm/exceptionhandler.h>
#include <giomm/file.h>

namespace {

static void
SignalProxy_async_callback(GObject*, GAsyncResult* res, void* data)
{
  Gio::SlotAsyncReady* the_slot = static_cast<Gio::SlotAsyncReady*>(data);

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    Glib::RefPtr<Gio::AsyncResult> result = Glib::wrap(res, true /* take copy */);
    (*the_slot)(result);
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  delete the_slot;
}

} // anonymous namespace

namespace Gio {

void
Volume::mount(const Glib::RefPtr<MountOperation>& mount_operation,
              const Glib::RefPtr<Cancellable>& cancellable,
              const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_volume_mount(gobj(),
                 mount_operation->gobj(),
                 cancellable->gobj(),
                 &SignalProxy_async_callback,
                 slot_copy);

}

void
Volume::mount(const Glib::RefPtr<MountOperation>& mount_operation,
              const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_volume_mount(gobj(),
                 mount_operation->gobj(),
                 NULL, // cancellable
                 &SignalProxy_async_callback,
                 slot_copy);
}

void Volume::eject(GMountUnmountFlags flags, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_volume_eject(gobj(),
                 flags, 
                 cancellable->gobj(),
                 &SignalProxy_async_callback,
                 slot_copy);
}

void Volume::eject(GMountUnmountFlags flags, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_volume_eject(gobj(),
                 flags, 
                 NULL,
                 &SignalProxy_async_callback,
                 slot_copy);
}

} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::Volume> wrap(GVolume* object, bool take_copy)
{
  return Glib::RefPtr<Gio::Volume>( dynamic_cast<Gio::Volume*> (Glib::wrap_auto_interface<Gio::Volume> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gio
{


/* The *_Class implementation: */

const Glib::Interface_Class& Volume_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &Volume_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = g_drive_get_type();
  }

  return *this;
}

void Volume_Class::iface_init_function(void* g_iface, void*)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != 0); 

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Volume_Class::wrap_new(GObject* object)
{
  return new Volume((GVolume*)(object));
}


/* The implementation: */

Volume::Volume()
:
  Glib::Interface(volume_class_.init())
{}

Volume::Volume(GVolume* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

Volume::~Volume()
{}

// static
void Volume::add_interface(GType gtype_implementer)
{
  volume_class_.init().add_interface(gtype_implementer);
}

Volume::CppClassType Volume::volume_class_; // initialize static member

GType Volume::get_type()
{
  return volume_class_.init().get_type();
}

GType Volume::get_base_type()
{
  return g_drive_get_type();
}


std::string Volume::get_name() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_volume_get_name(const_cast<GVolume*>(gobj())));
}

std::string Volume::get_uuid() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_volume_get_uuid(const_cast<GVolume*>(gobj())));
}

Glib::RefPtr<Icon> Volume::get_icon()
{

  Glib::RefPtr<Icon> retvalue = Glib::wrap(g_volume_get_icon(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Icon> Volume::get_icon() const
{
  return const_cast<Volume*>(this)->get_icon();
}

Glib::RefPtr<Drive> Volume::get_drive()
{

  Glib::RefPtr<Drive> retvalue = Glib::wrap(g_volume_get_drive(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Drive> Volume::get_drive() const
{
  return const_cast<Volume*>(this)->get_drive();
}

bool Volume::can_mount() const
{
  return g_volume_can_mount(const_cast<GVolume*>(gobj()));
}

bool Volume::can_eject() const
{
  return g_volume_can_eject(const_cast<GVolume*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Volume::mount_finish(const Glib::RefPtr<AsyncResult>& result)
#else
bool Volume::mount_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_volume_mount_finish(gobj(), Glib::unwrap(result), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Volume::eject_finish(const Glib::RefPtr<AsyncResult>& result)
#else
bool Volume::eject_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_volume_eject_finish(gobj(), Glib::unwrap(result), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gio


