/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

/**
 * Generic Exception in Java-GNOME. This exception wraps an org.gnu.glib.Error.
 */
public class JGException extends Exception {

    private static final long serialVersionUID = 3256725087058082105L;

    private Error error;

    public JGException(Error error) {
        super();
        this.error = error;
    }

    /**
     * @return Returns the error.
     */
    public Error getError() {
        return error;
    }

    /**
     * @param error
     *            The error to set.
     */
    public void setError(Error error) {
        this.error = error;
    }
}
