/*
 *  Author: tican
 *
 *  Declarations for Syscriptor.
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/sysinfo.h>

void memory(void)
{
	struct sysinfo info;
	int fram, fswap, tram, tswap;
	float frammb, fswapmb, trammb, tswapmb;

	if (sysinfo(&info) != -1) {
		tram = info.totalram;
		fram = info.freeram;
		tswap = info.totalswap;
		fswap = info.freeswap;
	} else {
		fprintf(stderr, "  Could not find information about your RAM or swap");
		return;
	}

	puts("");
	printf("  MEMORY\n\n");

	if ( tram ) {
		trammb = ((tram / 1024) / 1024);
		printf("  RAM:\n");
		printf("  Total:\t%4.0f MB\n", trammb);
		if ( fram ) {
			frammb = ((fram / 1024) / 1024);
			printf("  Free:\t\t%4.0f MB\n", frammb);
		}
	}

	if ( tswap ) {
		tswapmb = ((tswap / 1024) / 1024);
		puts("");
		printf("  Swap:\n");
		printf("  Total:\t%4.0f MB\n", tswapmb);
		if ( fswap ) {
			fswapmb = ((fswap / 1024) / 1024);
			printf("  Free:\t\t%4.0f MB\n", fswapmb);
		}
	}

	puts("");
}
