/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.builder.CodeBuilder;
import com.claritysys.jvm.classfile.Attribute;
import com.claritysys.jvm.classfile.AttributeHandler;
import com.claritysys.jvm.classfile.CfFieldOrMethod;
import com.claritysys.jvm.classfile.ClassFile;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import com.claritysys.jvm.classfile.ConstantPool;
import com.claritysys.jvm.classfile.CpClass;
import com.claritysys.jvm.classfile.CpRef;
import com.claritysys.jvm.classfile.CpUtf8;
import com.claritysys.jvm.classfile.ExceptionHandler;
import com.claritysys.jvm.classfile.LineNumber;
import com.claritysys.jvm.classfile.LocalVariable;
import com.claritysys.jvm.classfile.Utils;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class CfMethod
extends CfFieldOrMethod
implements AttributeHandler {
    private CfMethod next;
    private int returnType;
    private int[] exceptionCps;
    private int maxStack;
    private int maxLocals;
    private static final byte[] EMPTY_CODE = new byte[0];
    private byte[] code = EMPTY_CODE;
    private int handlerCount;
    private ExceptionHandler handlers;
    private ExceptionHandler lastHandler;
    private int localsCount;
    private LocalVariable locals;
    private LocalVariable lastLocal;
    private int lineCount;
    private LineNumber lines;
    private LineNumber lastLine;
    private Attribute codeAttributes;

    public CfMethod(ClassFile classFile) {
        super(classFile);
    }

    public CfMethod getNext() {
        return this.next;
    }

    public void setNext(CfMethod next) {
        this.next = next;
    }

    public void read(DataInputStream dataIn) throws IOException, ClassFileFormatException {
        super.read(dataIn);
        this.setAttributes(Attribute.readTable(dataIn, this.getConstantPool(), this));
        CpUtf8 descriptor = (CpUtf8)this.getConstantPool().getPoolEntry(this.descriptorIndex);
        this.returnType = Utils.getMethodReturnType(descriptor.getString());
    }

    public boolean handleAttribute(DataInputStream dataIn, String name, int length) throws IOException, ClassFileFormatException {
        boolean processed = false;
        if (name.equals("Deprecated")) {
            this.setDeprecated(true);
            processed = true;
        } else if (name.equals("Code")) {
            this.maxStack = dataIn.readUnsignedShort();
            this.maxLocals = dataIn.readUnsignedShort();
            int codeLength = dataIn.readInt();
            this.code = new byte[codeLength];
            dataIn.read(this.code);
            int handlerCount = dataIn.readUnsignedShort();
            for (int i = 0; i < handlerCount; ++i) {
                ExceptionHandler h = new ExceptionHandler(this, dataIn);
                this.addHandler(h);
            }
            this.setCodeAttributes(Attribute.readTable(dataIn, this.getConstantPool(), this));
            processed = true;
        } else if (name.equals("Exceptions")) {
            int count = dataIn.readUnsignedShort();
            this.exceptionCps = new int[count];
            for (int i = 0; i < count; ++i) {
                this.exceptionCps[i] = dataIn.readUnsignedShort();
            }
            processed = true;
        } else if (name.equals("Synthetic")) {
            this.setSynthetic(true);
            processed = true;
        } else if (name.equals("LineNumberTable")) {
            int tableSize = dataIn.readUnsignedShort();
            for (int i = 0; i < tableSize; ++i) {
                int startPc = dataIn.readUnsignedShort();
                int lineNumber = dataIn.readUnsignedShort();
                LineNumber line = new LineNumber(startPc, lineNumber);
                this.addLine(line);
            }
            processed = true;
        } else if (name.equals("LocalVariableTable")) {
            int tableSize = dataIn.readUnsignedShort();
            for (int i = 0; i < tableSize; ++i) {
                int startPc = dataIn.readUnsignedShort();
                int lvLength = dataIn.readUnsignedShort();
                int lvNameIndex = dataIn.readUnsignedShort();
                int lvTypeIndex = dataIn.readUnsignedShort();
                int lvSlot = dataIn.readUnsignedShort();
                ConstantPool constantPool = this.getConstantPool();
                CpUtf8 lvName = (CpUtf8)constantPool.getPoolEntry(lvNameIndex);
                CpUtf8 lvType = (CpUtf8)constantPool.getPoolEntry(lvTypeIndex);
                LocalVariable local = new LocalVariable(this, startPc, lvLength, lvName, lvType, lvSlot);
                this.addLocal(local);
            }
            processed = true;
        }
        return processed;
    }

    public void write(DataOutput dout) throws IOException {
        super.write(dout);
        int attributeCount = this.getAttributeCount();
        if (this.isSynthetic()) {
            ++attributeCount;
        }
        if (this.isDeprecated()) {
            ++attributeCount;
        }
        if (this.exceptionCps != null && this.exceptionCps.length > 0) {
            ++attributeCount;
        }
        if (this.code != null) {
            ++attributeCount;
        }
        dout.writeShort(attributeCount);
        ConstantPool cp = this.getConstantPool();
        if (this.isSynthetic()) {
            Attribute.writeAttribute(dout, cp, "Synthetic", 0);
        }
        if (this.isDeprecated()) {
            Attribute.writeAttribute(dout, cp, "Deprecated", 0);
        }
        if (this.exceptionCps != null && this.exceptionCps.length > 0) {
            Attribute.writeAttribute(dout, cp, "Exceptions", 2 + this.exceptionCps.length * 2);
            dout.writeShort(this.exceptionCps.length);
            for (int i = 0; i < this.exceptionCps.length; ++i) {
                dout.writeShort(this.exceptionCps[i]);
            }
        }
        if (this.code != null) {
            this.writeCodeAttribute(dout);
        }
        Attribute.writeTable(dout, this.getAttributes());
    }

    private void writeCodeAttribute(DataOutput dout) throws IOException {
        Attribute codeAttributes;
        int attributesLength = Attribute.getTotalSize(this.getCodeAttributes());
        if (this.localsCount > 0) {
            attributesLength += 8 + 10 * this.localsCount;
        }
        if (this.lineCount > 0) {
            attributesLength += 8 + 4 * this.lineCount;
        }
        int codeAttrLength = 12 + this.code.length + 8 * this.handlerCount + attributesLength;
        int nameIndex = this.getConstantPool().addUtf8("Code").getIndex();
        dout.writeShort(nameIndex);
        dout.writeInt(codeAttrLength);
        dout.writeShort(this.maxStack);
        dout.writeShort(this.maxLocals);
        dout.writeInt(this.code.length);
        dout.write(this.code);
        dout.writeShort(this.handlerCount);
        for (ExceptionHandler h = this.handlers; h != null; h = h.getNext()) {
            dout.writeShort(h.getStartPc());
            dout.writeShort(h.getEndPc());
            dout.writeShort(h.getHandlerPc());
            dout.writeShort(h.getExceptionClassIndex());
        }
        int attributeCount = 0;
        for (Attribute a = codeAttributes = this.getCodeAttributes(); a != null; a = a.getNext()) {
            ++attributeCount;
        }
        if (this.getLocals() != null) {
            ++attributeCount;
        }
        if (this.getLines() != null) {
            ++attributeCount;
        }
        dout.writeShort(attributeCount);
        ConstantPool cp = this.getConstantPool();
        if (this.getLocals() != null) {
            Attribute.writeAttribute(dout, cp, "LocalVariableTable", 2 + 10 * this.localsCount);
            dout.writeShort(this.localsCount);
            for (LocalVariable local = this.locals; local != null; local = local.getNext()) {
                dout.writeShort(local.getStartPc());
                dout.writeShort(local.getLength());
                dout.writeShort(local.getName().getIndex());
                dout.writeShort(local.getDescriptor().getIndex());
                dout.writeShort(local.getIndex());
            }
        }
        if (this.getLines() != null) {
            int lineCount = this.getLineCount();
            Attribute.writeAttribute(dout, cp, "LineNumberTable", 2 + 4 * lineCount);
            dout.writeShort(lineCount);
            for (LineNumber line = this.getLines(); line != null; line = line.getNext()) {
                dout.writeShort(line.getPc());
                dout.writeShort(line.getLine());
            }
        }
        Attribute.writeTable(dout, codeAttributes);
    }

    public void addLocal(LocalVariable local) {
        if (this.locals == null) {
            this.locals = this.lastLocal = local;
        } else {
            this.lastLocal.setNext(local);
            this.lastLocal = local;
        }
        ++this.localsCount;
    }

    public void addLine(LineNumber line) {
        if (this.lines == null) {
            this.lines = this.lastLine = line;
        } else {
            this.lastLine.setNext(line);
            this.lastLine = line;
        }
        ++this.lineCount;
    }

    public int getReturnType() {
        return this.returnType;
    }

    void setReturnType(int returnType) {
        this.returnType = returnType;
    }

    public Attribute getCodeAttributes() {
        return this.codeAttributes;
    }

    public void setCodeAttributes(Attribute codeAttributes) {
        this.codeAttributes = codeAttributes;
    }

    public void addHandler(ExceptionHandler h) {
        if (this.handlers == null) {
            this.handlers = this.lastHandler = h;
        } else {
            this.lastHandler.setNext(h);
            this.lastHandler = h;
        }
        ++this.handlerCount;
    }

    public void addHandler(int startPc, int endPc, int handlerPc, CpClass catchType) {
        ExceptionHandler handler = new ExceptionHandler(this, startPc, endPc, handlerPc, catchType.getIndex());
        this.addHandler(handler);
    }

    public int[] getExceptionCps() {
        return this.exceptionCps;
    }

    public void setExceptionCps(int[] exceptionCps) {
        this.exceptionCps = exceptionCps;
    }

    public void setExceptions(Class[] exceptions) {
        int[] cps = new int[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            Class exception = exceptions[i];
            cps[i] = this.getConstantPool().addClass(exception).getIndex();
        }
        this.setExceptionCps(cps);
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] code) {
        this.code = code;
    }

    public int getHandlerCount() {
        return this.handlerCount;
    }

    public void setHandlerCount(int handlerCount) {
        this.handlerCount = handlerCount;
    }

    public ExceptionHandler getHandlers() {
        return this.handlers;
    }

    public void setHandlers(ExceptionHandler handlers) {
        this.handlers = handlers;
    }

    public ExceptionHandler getLastHandler() {
        return this.lastHandler;
    }

    public void setLastHandler(ExceptionHandler lastHandler) {
        this.lastHandler = lastHandler;
    }

    public int getLocalsCount() {
        return this.localsCount;
    }

    public void setLocalsCount(int localsCount) {
        this.localsCount = localsCount;
    }

    public LocalVariable getLocals() {
        return this.locals;
    }

    public void setLocals(LocalVariable locals) {
        this.locals = locals;
    }

    public void createLocalsFromSignature() {
        String sig;
        if (this.getLocals() != null) {
            throw new IllegalStateException("Locals already exist");
        }
        String vmMethodSig = this.getRef().getNameAndType().getType().getString();
        int nextLocalIndex = 0;
        if (!this.isStatic()) {
            String name = "this";
            CpUtf8 nameCp = this.getConstantPool().addUtf8(name);
            sig = "L" + this.getClassFile().getClassName() + ";";
            CpUtf8 sigCp = this.getConstantPool().addUtf8(sig);
            LocalVariable local = new LocalVariable(this, 0, 0, nameCp, sigCp, nextLocalIndex);
            ++nextLocalIndex;
            this.addLocal(local);
        }
        String[] parameters = Utils.getParameters(vmMethodSig);
        for (int i = 0; i < parameters.length; ++i) {
            sig = parameters[i];
            String name = "param" + i;
            CpUtf8 nameCp = this.getConstantPool().addUtf8(name);
            CpUtf8 sigCp = this.getConstantPool().addUtf8(sig);
            LocalVariable local = new LocalVariable(this, 0, 0, nameCp, sigCp, nextLocalIndex);
            nextLocalIndex += Utils.getStackWords(sig);
            this.addLocal(local);
        }
        if (nextLocalIndex != this.getMaxLocals()) {
            throw new IllegalStateException("maxLocals(" + this.getMaxLocals() + ")" + " != nextLocalIndex(" + nextLocalIndex + ")");
        }
    }

    public LocalVariable getLocal(int index) {
        for (LocalVariable lv = this.getLocals(); lv != null; lv = lv.getNext()) {
            if (lv.getIndex() != index) continue;
            return lv;
        }
        return null;
    }

    public LocalVariable getLastLocal() {
        return this.lastLocal;
    }

    public void setLastLocal(LocalVariable lastLocal) {
        this.lastLocal = lastLocal;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(int lineCount) {
        this.lineCount = lineCount;
    }

    public LineNumber getLines() {
        return this.lines;
    }

    public void setLines(LineNumber lines) {
        this.lines = lines;
    }

    public LineNumber getLastLine() {
        return this.lastLine;
    }

    public void setLastLine(LineNumber lastLine) {
        this.lastLine = lastLine;
    }

    public CpRef getRef() {
        int classCp = this.classFile.getClassIndex();
        return this.getConstantPool().addMethodRef(classCp, this.nameIndex, this.descriptorIndex);
    }

    public CodeBuilder getCodeBuilder() {
        return this.classFile.getCodeBuilder(this);
    }
}

