/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class GetInfoMulti
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoMulti theDialog = null;
    private DefaultListModel listModel;
    private JList list;
    private List highlightList = new ArrayList();
    private String initialXPosition;
    private String initialYPosition;
    private String initialXSize;
    private String initialYSize;
    private String initialWidth;
    private int numNodes;
    private int numArcs;
    private int numExports;
    private JButton apply;
    private JButton cancel;
    private JComboBox characteristics;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JScrollPane listPane;
    private JButton ok;
    private JButton remove;
    private JButton removeOthers;
    private JComboBox selection;
    private JLabel selectionCount;
    private JTextField width;
    private JLabel widthRange;
    private JTextField xPosition;
    private JLabel xPositionRange;
    private JTextField xSize;
    private JLabel xSizeRange;
    private JTextField yPosition;
    private JLabel yPositionRange;
    private JTextField ySize;
    private JLabel ySizeRange;

    public static void showDialog() {
        if (theDialog == null) {
            TopLevel jf = TopLevel.getCurrentJFrame();
            theDialog = new GetInfoMulti((Frame)jf, false);
        }
        theDialog.loadMultiInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
        }
        theDialog.setVisible(true);
    }

    public void highlightChanged() {
        if (!this.isVisible()) {
            return;
        }
        this.loadMultiInfo();
    }

    public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
        if (!this.isVisible()) {
            return;
        }
        boolean reload = false;
        Iterator it = batch.getChanges();
        block0: while (it.hasNext()) {
            Undo.Change change = (Undo.Change)it.next();
            ElectricObject obj = change.getObject();
            Iterator it2 = this.highlightList.iterator();
            while (it2.hasNext()) {
                Highlight h = (Highlight)it2.next();
                if (obj != h.getElectricObject()) continue;
                reload = true;
                continue block0;
            }
        }
        if (reload) {
            this.loadMultiInfo();
        }
    }

    public void databaseChanged(Undo.Change change) {
    }

    private GetInfoMulti(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.setLocation(100, 50);
        Highlight.addHighlightListener(this);
        Undo.addDatabaseChangeListener(this);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(2);
        this.listPane.setViewportView(this.list);
        this.characteristics.addItem("Leave selection alone");
        Iterator it = PortProto.Characteristic.getOrderedCharacteristics().iterator();
        while (it.hasNext()) {
            PortProto.Characteristic ch = (PortProto.Characteristic)it.next();
            this.characteristics.addItem(ch.getName());
        }
        this.selection.addItem("Leave selection alone");
        this.selection.addItem("Make all Hard-to-select");
        this.selection.addItem("Make all Easy-to-select");
        this.loadMultiInfo();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    private void loadMultiInfo() {
        this.highlightList.clear();
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            this.highlightList.add(it.next());
        }
        Collections.sort(this.highlightList, new SortMultipleHighlights());
        this.numExports = 0;
        this.numArcs = 0;
        this.numNodes = 0;
        Geometric firstGeom = null;
        Geometric secondGeom = null;
        double xPositionLow = 0.0;
        double xPositionHigh = 0.0;
        double yPositionLow = 0.0;
        double yPositionHigh = 0.0;
        double xSizeLow = 0.0;
        double xSizeHigh = 0.0;
        double ySizeLow = 0.0;
        double ySizeHigh = 0.0;
        double widthLow = 0.0;
        double widthHigh = 0.0;
        this.selectionCount.setText(Integer.toString(this.highlightList.size()) + " selections:");
        this.listModel.clear();
        Iterator it2 = this.highlightList.iterator();
        while (it2.hasNext()) {
            String description;
            Highlight h = (Highlight)it2.next();
            ElectricObject eobj = h.getElectricObject();
            if (h.getType() == Highlight.Type.EOBJ) {
                description = "";
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (eobj instanceof Geometric) {
                    if (firstGeom == null) {
                        firstGeom = (Geometric)eobj;
                    } else if (secondGeom == null) {
                        secondGeom = (Geometric)eobj;
                    }
                }
                if (eobj instanceof NodeInst) {
                    NodeInst ni = (NodeInst)eobj;
                    if (this.numNodes != 0) {
                        xPositionLow = Math.min(xPositionLow, ni.getAnchorCenterX());
                        xPositionHigh = Math.max(xPositionHigh, ni.getAnchorCenterX());
                        yPositionLow = Math.min(yPositionLow, ni.getAnchorCenterY());
                        yPositionHigh = Math.max(yPositionHigh, ni.getAnchorCenterY());
                        xSizeLow = Math.min(xSizeLow, ni.getXSize());
                        xSizeHigh = Math.max(xSizeHigh, ni.getXSize());
                        ySizeLow = Math.min(ySizeLow, ni.getYSize());
                        ySizeHigh = Math.max(ySizeHigh, ni.getYSize());
                    } else {
                        xPositionLow = xPositionHigh = ni.getAnchorCenterX();
                        yPositionLow = yPositionHigh = ni.getAnchorCenterY();
                        xSizeLow = xSizeHigh = ni.getXSize();
                        ySizeLow = ySizeHigh = ni.getYSize();
                    }
                    ++this.numNodes;
                    description = "Node " + ni.describe();
                } else if (eobj instanceof ArcInst) {
                    ArcInst ai = (ArcInst)eobj;
                    double trueWidth = ai.getWidth() - ai.getProto().getWidthOffset();
                    if (this.numArcs != 0) {
                        widthLow = Math.min(widthLow, trueWidth);
                        widthHigh = Math.max(widthHigh, trueWidth);
                    } else {
                        widthLow = widthHigh = trueWidth;
                    }
                    ++this.numArcs;
                    description = "Arc " + ai.describe();
                }
                this.listModel.addElement(description);
                continue;
            }
            if (h.getType() == Highlight.Type.TEXT) {
                description = "Text: unknown";
                if (h.getVar() != null) {
                    description = "Text: " + h.getVar().getFullDescription(eobj);
                } else if (h.getName() != null) {
                    if (eobj instanceof NodeInst) {
                        description = "Node name for " + ((NodeInst)eobj).describe();
                    } else if (eobj instanceof ArcInst) {
                        description = "Arc name for " + ((ArcInst)eobj).describe();
                    }
                } else if (eobj instanceof Export) {
                    description = "Text: Export '" + ((Export)eobj).getName() + "'";
                    ++this.numExports;
                } else if (eobj instanceof NodeInst) {
                    description = "Text: Cell instance name " + ((NodeInst)eobj).describe();
                }
                this.listModel.addElement(description);
                continue;
            }
            if (h.getType() == Highlight.Type.LINE) {
                Point2D pt1 = h.getFromPoint();
                Point2D pt2 = h.getToPoint();
                String description2 = "Line from (" + pt1.getX() + "," + pt1.getY() + ") to (" + pt2.getX() + "," + pt2.getY() + ")";
                this.listModel.addElement(description2);
                continue;
            }
            if (h.getType() != Highlight.Type.BBOX) continue;
            Rectangle2D bounds = h.getBounds();
            String description3 = "Area from " + bounds.getMinX() + "<=X<=" + bounds.getMaxX() + " and " + bounds.getMinY() + "<=Y<=" + bounds.getMaxY();
            this.listModel.addElement(description3);
        }
        if (this.numNodes + this.numArcs == 2) {
            this.listModel.addElement("---------------------------");
            Point2D firstPt = firstGeom.getTrueCenter();
            if (firstGeom instanceof NodeInst) {
                firstPt = ((NodeInst)firstGeom).getAnchorCenter();
            }
            Point2D secondPt = secondGeom.getTrueCenter();
            if (secondGeom instanceof NodeInst) {
                secondPt = ((NodeInst)secondGeom).getAnchorCenter();
            }
            this.listModel.addElement("Distance between centers: X=" + Math.abs(firstPt.getX() - secondPt.getX()) + " Y=" + Math.abs(firstPt.getY() - secondPt.getY()));
        }
        if (this.numNodes != 0) {
            this.initialXPosition = "";
            if (xPositionLow == xPositionHigh) {
                this.initialXPosition = Double.toString(xPositionLow);
                this.xPositionRange.setText("All the same");
            } else {
                this.xPositionRange.setText(xPositionLow + " to " + xPositionHigh);
            }
            this.xPosition.setEditable(true);
            this.xPosition.setText(this.initialXPosition);
            this.initialYPosition = "";
            if (yPositionLow == yPositionHigh) {
                this.initialYPosition = Double.toString(yPositionLow);
                this.yPositionRange.setText("All the same");
            } else {
                this.yPositionRange.setText(yPositionLow + " to " + yPositionHigh);
            }
            this.yPosition.setEditable(true);
            this.yPosition.setText(this.initialYPosition);
            this.initialXSize = "";
            if (xSizeLow == xSizeHigh) {
                this.initialXSize = Double.toString(xSizeLow);
                this.xSizeRange.setText("All the same");
            } else {
                this.xSizeRange.setText(xSizeLow + " to " + xSizeHigh);
            }
            this.xSize.setEditable(true);
            this.xSize.setText(this.initialXSize);
            this.initialYSize = "";
            if (ySizeLow == ySizeHigh) {
                this.initialYSize = Double.toString(ySizeLow);
                this.ySizeRange.setText("All the same");
            } else {
                this.ySizeRange.setText(ySizeLow + " to " + ySizeHigh);
            }
            this.ySize.setEditable(true);
            this.ySize.setText(this.initialYSize);
        } else {
            this.xPosition.setEditable(false);
            this.xPosition.setText("");
            this.xPositionRange.setText("");
            this.yPosition.setEditable(false);
            this.yPosition.setText("");
            this.yPositionRange.setText("");
            this.xSize.setEditable(false);
            this.xSize.setText("");
            this.xSizeRange.setText("");
            this.ySize.setEditable(false);
            this.ySize.setText("");
            this.ySizeRange.setText("");
        }
        if (this.numArcs != 0) {
            this.initialWidth = "";
            if (widthLow == widthHigh) {
                this.initialWidth = Double.toString(widthLow);
                this.widthRange.setText("All the same");
            } else {
                this.widthRange.setText(widthLow + " to " + widthHigh);
            }
            this.width.setEditable(true);
            this.width.setText(this.initialWidth);
        } else {
            this.width.setEditable(false);
            this.width.setText("");
            this.widthRange.setText("");
        }
        this.characteristics.setEnabled(this.numExports != 0);
        if (this.numNodes == 0 && this.numArcs == 0) {
            this.listPane.setEnabled(false);
            this.remove.setEnabled(false);
            this.removeOthers.setEnabled(false);
            this.apply.setEnabled(false);
            this.selection.setEnabled(false);
        } else {
            this.listPane.setEnabled(true);
            this.remove.setEnabled(true);
            this.removeOthers.setEnabled(true);
            this.apply.setEnabled(true);
            this.selection.setEnabled(true);
        }
    }

    private void initComponents() {
        this.removeOthers = new JButton();
        this.apply = new JButton();
        this.selectionCount = new JLabel();
        this.jLabel2 = new JLabel();
        this.listPane = new JScrollPane();
        this.jLabel3 = new JLabel();
        this.xPosition = new JTextField();
        this.xPositionRange = new JLabel();
        this.jLabel5 = new JLabel();
        this.yPosition = new JTextField();
        this.yPositionRange = new JLabel();
        this.jLabel7 = new JLabel();
        this.xSize = new JTextField();
        this.xSizeRange = new JLabel();
        this.jLabel9 = new JLabel();
        this.ySize = new JTextField();
        this.ySizeRange = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.width = new JTextField();
        this.widthRange = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel14 = new JLabel();
        this.characteristics = new JComboBox();
        this.jSeparator3 = new JSeparator();
        this.jLabel15 = new JLabel();
        this.selection = new JComboBox();
        this.ok = new JButton();
        this.remove = new JButton();
        this.cancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Multi-Object Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoMulti.this.closeDialog(evt);
            }
        });
        this.removeOthers.setText("Remove Others");
        this.removeOthers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.removeOthersActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.removeOthers, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.selectionCount.setText("0 selections:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.getContentPane().add((Component)this.selectionCount, gridBagConstraints);
        this.jLabel2.setText("For all selected nodes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(300, 22));
        this.listPane.setPreferredSize(new Dimension(300, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.jLabel3.setText("X Position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.xPosition.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xPosition, gridBagConstraints);
        this.xPositionRange.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xPositionRange, gridBagConstraints);
        this.jLabel5.setText("Y Position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.yPosition.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yPosition, gridBagConstraints);
        this.yPositionRange.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yPositionRange, gridBagConstraints);
        this.jLabel7.setText("X Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        this.xSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xSize, gridBagConstraints);
        this.xSizeRange.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xSizeRange, gridBagConstraints);
        this.jLabel9.setText("Y Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.ySize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ySize, gridBagConstraints);
        this.ySizeRange.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ySizeRange, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel11.setText("For all selected arcs:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel12, gridBagConstraints);
        this.width.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.width, gridBagConstraints);
        this.widthRange.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.widthRange, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.jLabel14.setText("For all selected exports:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel14, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.characteristics, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator3, gridBagConstraints);
        this.jLabel15.setText("For everything:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.selection, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.remove.setText("Remove");
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.removeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.remove, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoMulti.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 19;
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void removeActionPerformed(ActionEvent evt) {
        int[] items = this.list.getSelectedIndices();
        ArrayList newList = new ArrayList();
        for (int i = 0; i < this.highlightList.size(); ++i) {
            int j;
            for (j = 0; j < items.length && i != items[j]; ++j) {
            }
            if (j < items.length) continue;
            newList.add(this.highlightList.get(i));
        }
        Highlight.clear();
        Highlight.setHighlightList(newList);
        Highlight.finished();
    }

    private void applyActionPerformed(ActionEvent evt) {
        MultiChange job = new MultiChange(this);
    }

    private void removeOthersActionPerformed(ActionEvent evt) {
        int[] items = this.list.getSelectedIndices();
        ArrayList newList = new ArrayList();
        for (int i = 0; i < this.highlightList.size(); ++i) {
            int j;
            for (j = 0; j < items.length && i != items[j]; ++j) {
            }
            if (j >= items.length) continue;
            newList.add(this.highlightList.get(i));
        }
        this.highlightList = newList;
        Highlight.clear();
        Highlight.setHighlightList(newList);
        Highlight.finished();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    private static class MultiChange
    extends Job {
        GetInfoMulti dialog;

        protected MultiChange(GetInfoMulti dialog) {
            super("Modify Objects", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            int exportCharacteristics;
            int selectEase;
            String currentWidth;
            String currentXPosition = this.dialog.xPosition.getText();
            String currentYPosition = this.dialog.yPosition.getText();
            String currentXSize = this.dialog.xSize.getText();
            String currentYSize = this.dialog.ySize.getText();
            if (!(currentXPosition.equals(this.dialog.initialXPosition) && currentYPosition.equals(this.dialog.initialYPosition) && currentXSize.equals(this.dialog.initialXSize) && currentYSize.equals(this.dialog.initialYSize))) {
                double newXPosition = TextUtils.atof(currentXPosition);
                double newYPosition = TextUtils.atof(currentYPosition);
                double newXSize = TextUtils.atof(currentXSize);
                double newYSize = TextUtils.atof(currentYSize);
                NodeInst[] nis = new NodeInst[this.dialog.numNodes];
                double[] dXP = new double[this.dialog.numNodes];
                double[] dYP = new double[this.dialog.numNodes];
                double[] dXS = new double[this.dialog.numNodes];
                double[] dYS = new double[this.dialog.numNodes];
                int[] dRot = new int[this.dialog.numNodes];
                int index = 0;
                Iterator it = this.dialog.highlightList.iterator();
                while (it.hasNext()) {
                    NodeInst ni;
                    ElectricObject eobj;
                    Highlight h = (Highlight)it.next();
                    if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof NodeInst)) continue;
                    nis[index] = ni = (NodeInst)eobj;
                    dXP[index] = currentXPosition.equals("") ? 0.0 : newXPosition - ni.getAnchorCenterX();
                    dYP[index] = currentYPosition.equals("") ? 0.0 : newYPosition - ni.getAnchorCenterY();
                    dXS[index] = currentXSize.equals("") ? 0.0 : newXSize - ni.getXSize();
                    dYS[index] = currentYSize.equals("") ? 0.0 : newYSize - ni.getYSize();
                    dRot[index] = 0;
                    ++index;
                }
                NodeInst.modifyInstances(nis, dXP, dYP, dXS, dYS, dRot);
                this.dialog.initialXPosition = currentXPosition;
                this.dialog.initialYPosition = currentYPosition;
                this.dialog.initialXSize = currentXSize;
                this.dialog.initialYSize = currentYSize;
            }
            if (!(currentWidth = this.dialog.width.getText()).equals(this.dialog.initialWidth)) {
                double newWidth = TextUtils.atof(currentWidth);
                Iterator it = this.dialog.highlightList.iterator();
                while (it.hasNext()) {
                    ElectricObject eobj;
                    Highlight h = (Highlight)it.next();
                    if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst)) continue;
                    ArcInst ai = (ArcInst)eobj;
                    ai.modify(newWidth - (ai.getWidth() - ai.getProto().getWidthOffset()), 0.0, 0.0, 0.0, 0.0);
                }
                this.dialog.initialWidth = currentWidth;
            }
            if ((selectEase = this.dialog.selection.getSelectedIndex()) != 0) {
                Iterator it = this.dialog.highlightList.iterator();
                while (it.hasNext()) {
                    Highlight h = (Highlight)it.next();
                    if (h.getType() != Highlight.Type.EOBJ) continue;
                    ElectricObject eobj = h.getElectricObject();
                    if (eobj instanceof NodeInst) {
                        NodeInst ni = (NodeInst)eobj;
                        if (selectEase == 1) {
                            ni.setHardSelect();
                            continue;
                        }
                        ni.clearHardSelect();
                        continue;
                    }
                    ArcInst ai = (ArcInst)eobj;
                    if (selectEase == 1) {
                        ai.setHardSelect();
                        continue;
                    }
                    ai.clearHardSelect();
                }
            }
            if ((exportCharacteristics = this.dialog.characteristics.getSelectedIndex()) != 0) {
                String charName = (String)this.dialog.characteristics.getSelectedItem();
                PortProto.Characteristic ch = PortProto.Characteristic.findCharacteristic(charName);
                Iterator it = this.dialog.highlightList.iterator();
                while (it.hasNext()) {
                    Highlight h = (Highlight)it.next();
                    if (h.getType() != Highlight.Type.TEXT || h.getVar() != null || !(h.getElectricObject() instanceof Export)) continue;
                    Export pp = (Export)h.getElectricObject();
                    pp.setCharacteristic(ch);
                }
            }
            return true;
        }
    }

    private static class SortMultipleHighlights
    implements Comparator {
        private SortMultipleHighlights() {
        }

        public int compare(Object o1, Object o2) {
            Highlight h1 = (Highlight)o1;
            Highlight h2 = (Highlight)o2;
            if (h1.getType() != h2.getType()) {
                return h1.getType().getOrder() - h2.getType().getOrder();
            }
            if (h1.getType() != Highlight.Type.EOBJ) {
                return 0;
            }
            ElectricObject e1 = h1.getElectricObject();
            int type1 = 0;
            if (e1 instanceof NodeInst) {
                type1 = 1;
            } else if (e1 instanceof ArcInst) {
                type1 = 2;
            }
            ElectricObject e2 = h2.getElectricObject();
            int type2 = 0;
            if (e2 instanceof NodeInst) {
                type2 = 1;
            } else if (e2 instanceof ArcInst) {
                type2 = 2;
            }
            if (type1 != type2) {
                return type1 - type2;
            }
            String s1 = e1.toString();
            if (e1 instanceof Geometric) {
                s1 = ((Geometric)e1).describe();
            }
            String s2 = e2.toString();
            if (e2 instanceof Geometric) {
                s2 = ((Geometric)e2).describe();
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

