/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NccUtils {
    public static String fullName(Cell c) {
        return c.getLibrary().getName() + ":" + c.getName() + "{" + c.getView().getAbbreviation() + "}";
    }

    public static Cell[] findSchematicAndLayout(Cell cell) {
        Cell.CellGroup group = cell.getCellGroup();
        Cell layout = null;
        Cell schematic = null;
        Iterator it = group.getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (c.getView() == View.SCHEMATIC) {
                schematic = c;
                continue;
            }
            if (c.getView() != View.LAYOUT) continue;
            layout = c;
        }
        if (schematic != null && layout != null) {
            return new Cell[]{schematic, layout};
        }
        return null;
    }

    public static CellContext getCurrentCellContext() {
        EditWindow wnd = EditWindow.getCurrent();
        return NccUtils.getCellContext(wnd);
    }

    public static CellContext getCellContext(EditWindow wnd) {
        if (wnd == null) {
            return null;
        }
        Cell cell = wnd.getCell();
        VarContext context = wnd.getVarContext();
        return new CellContext(cell, context);
    }

    public static List getCellContextsFromWindows() {
        ArrayList<CellContext> cellCtxts = new ArrayList<CellContext>();
        EditWindow wnd = EditWindow.getCurrent();
        CellContext curCellCtxt = NccUtils.getCellContext(wnd);
        if (curCellCtxt == null) {
            return cellCtxts;
        }
        cellCtxts.add(curCellCtxt);
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            EditWindow wnd2;
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (wnd2 = (EditWindow)content) == wnd) continue;
            CellContext cc = NccUtils.getCellContext((EditWindow)content);
            cellCtxts.add(cc);
        }
        return cellCtxts;
    }

    public static boolean hasSkipAnnotation(Cell c) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(c);
        if (ann == null) {
            return false;
        }
        String reason = ann.getSkipReason();
        if (reason != null) {
            System.out.println("Skip NCC of " + NccUtils.fullName(c) + " because " + reason);
            return true;
        }
        return false;
    }
}

