/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import java.util.HashMap;

public class Layer {
    private String name;
    private int index;
    private Technology tech;
    private EGraphics graphics;
    private Function function;
    private int functionExtras;
    private String cifLayer;
    private String dxfLayer;
    private String gdsLayer;
    private String skillLayer;
    private double thickness;
    private double height;
    private double resistance;
    private double capacitance;
    private double edgeCapacitance;
    private Layer nonPseudoLayer;
    private boolean visible;
    private PrimitiveNode pureLayerNode;
    private static HashMap cifLayerPrefs = new HashMap();
    private static HashMap gdsLayerPrefs = new HashMap();
    private static HashMap dxfLayerPrefs = new HashMap();
    private static HashMap skillLayerPrefs = new HashMap();
    private static HashMap resistanceParasiticPrefs = new HashMap();
    private static HashMap capacitanceParasiticPrefs = new HashMap();
    private static HashMap edgeCapacitanceParasiticPrefs = new HashMap();
    private static HashMap layerThicknessPrefs = new HashMap();
    private static HashMap layerHeightPrefs = new HashMap();

    private Layer(String name, Technology tech, EGraphics graphics) {
        this.name = name;
        this.tech = tech;
        this.graphics = graphics;
        this.nonPseudoLayer = this;
        this.visible = true;
    }

    public static Layer newInstance(Technology tech, String name, EGraphics graphics) {
        Layer layer = new Layer(name, tech, graphics);
        graphics.setLayer(layer);
        if (tech != null) {
            tech.addLayer(layer);
        }
        return layer;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    public EGraphics getGraphics() {
        return this.graphics;
    }

    public void setFunction(Function function) {
        this.function = function;
        this.functionExtras = 0;
    }

    public void setFunction(Function function, int functionExtras) {
        this.function = function;
        this.functionExtras = functionExtras;
    }

    public Function getFunction() {
        return this.function;
    }

    public int getFunctionExtras() {
        return this.functionExtras;
    }

    public void setPureLayerNode(PrimitiveNode pln) {
        this.pureLayerNode = pln;
    }

    public PrimitiveNode getPureLayerNode() {
        return this.pureLayerNode;
    }

    public boolean isNonElectrical() {
        return (this.functionExtras & 0x2000) != 0;
    }

    public Layer getNonPseudoLayer() {
        return this.nonPseudoLayer;
    }

    public void setNonPseudoLayer(Layer nonPseudoLayer) {
        this.nonPseudoLayer = nonPseudoLayer;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    private Pref getLayerPref(String what, HashMap map, String factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            if (factory == null) {
                factory = "";
            }
            pref = Pref.makeStringPref(what + "LayerFor" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            pref.attachToObject(this.tech, "IO/" + what + " tab", what + " for layer " + this.name + " in technology " + this.tech.getTechName());
            map.put(this, pref);
        }
        return pref;
    }

    private Pref getParasiticPref(String what, HashMap map, double factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref(what + "ParasiticFor" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            pref.attachToObject(this.tech, "Tools/Spice tab", "Technology " + this.tech.getTechName() + ", " + what + " for layer " + this.name);
            map.put(this, pref);
        }
        return pref;
    }

    private Pref get3DPref(String what, HashMap map, double factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref(what + "Of" + this.name + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            map.put(this, pref);
        }
        return pref;
    }

    public void setFactory3DInfo(double thickness, double height) {
        this.get3DPref("Thickness", layerThicknessPrefs, thickness);
        this.get3DPref("Height", layerHeightPrefs, height);
        this.thickness = thickness;
        this.height = height;
    }

    public double getHeight() {
        return this.get3DPref("Height", layerHeightPrefs, this.height).getDouble();
    }

    public void setHeight(double height) {
        this.get3DPref("Height", layerHeightPrefs, this.height).setDouble(height);
    }

    public double getThickness() {
        return this.get3DPref("Thickness", layerThicknessPrefs, this.thickness).getDouble();
    }

    public void setThickness(double thickness) {
        this.get3DPref("Thickness", layerThicknessPrefs, thickness).setDouble(thickness);
    }

    public void setFactoryCIFLayer(String cifLayer) {
        this.getLayerPref("CIF", cifLayerPrefs, cifLayer);
    }

    public void setCIFLayer(String cifLayer) {
        this.getLayerPref("CIF", cifLayerPrefs, this.cifLayer).setString(cifLayer);
    }

    public String getCIFLayer() {
        return this.getLayerPref("CIF", cifLayerPrefs, this.cifLayer).getString();
    }

    public void setFactoryGDSLayer(String gdsLayer) {
        this.getLayerPref("GDS", gdsLayerPrefs, gdsLayer);
    }

    public void setGDSLayer(String gdsLayer) {
        this.getLayerPref("GDS", gdsLayerPrefs, this.gdsLayer).setString(gdsLayer);
    }

    public String getGDSLayer() {
        return this.getLayerPref("GDS", gdsLayerPrefs, this.gdsLayer).getString();
    }

    public void setFactoryDXFLayer(String dxfLayer) {
        this.getLayerPref("DXF", dxfLayerPrefs, dxfLayer);
    }

    public void setDXFLayer(String dxfLayer) {
        this.getLayerPref("DXF", dxfLayerPrefs, this.dxfLayer).setString(dxfLayer);
    }

    public String getDXFLayer() {
        return this.getLayerPref("DXF", dxfLayerPrefs, this.dxfLayer).getString();
    }

    public void setFactorySkillLayer(String skillLayer) {
        this.getLayerPref("Skill", skillLayerPrefs, skillLayer);
    }

    public void setSkillLayer(String skillLayer) {
        this.getLayerPref("Skill", skillLayerPrefs, this.skillLayer).setString(skillLayer);
    }

    public String getSkillLayer() {
        return this.getLayerPref("Skill", skillLayerPrefs, this.skillLayer).getString();
    }

    public void setFactoryParasitics(double resistance, double capacitance, double edgeCapacitance) {
        this.resistance = resistance;
        this.getParasiticPref("Resistance", resistanceParasiticPrefs, this.resistance);
        this.capacitance = capacitance;
        this.getParasiticPref("Capacitance", capacitanceParasiticPrefs, this.capacitance);
        this.edgeCapacitance = edgeCapacitance;
        this.getParasiticPref("EdgeCapacitance", edgeCapacitanceParasiticPrefs, this.edgeCapacitance);
    }

    public double getResistance() {
        return this.getParasiticPref("Resistance", resistanceParasiticPrefs, this.resistance).getDouble();
    }

    public void setResistance(double resistance) {
        this.getParasiticPref("Resistance", resistanceParasiticPrefs, this.resistance).setDouble(resistance);
    }

    public double getCapacitance() {
        return this.getParasiticPref("Capacitance", capacitanceParasiticPrefs, this.capacitance).getDouble();
    }

    public void setCapacitance(double capacitance) {
        this.getParasiticPref("Capacitance", capacitanceParasiticPrefs, this.capacitance).setDouble(capacitance);
    }

    public double getEdgeCapacitance() {
        return this.getParasiticPref("EdgeCapacitance", edgeCapacitanceParasiticPrefs, this.edgeCapacitance).getDouble();
    }

    public void setEdgeCapacitance(double edgeCapacitance) {
        this.getParasiticPref("EdgeCapacitance", edgeCapacitanceParasiticPrefs, this.edgeCapacitance).setDouble(edgeCapacitance);
    }

    public String toString() {
        return "Layer " + this.name;
    }

    public static class Function {
        private final String name;
        private final int level;
        private final int height;
        private final int extraBits;
        public static final int PTYPE = 64;
        public static final int NTYPE = 128;
        public static final int DEPLETION = 256;
        public static final int ENHANCEMENT = 512;
        public static final int LIGHT = 1024;
        public static final int HEAVY = 2048;
        public static final int PSEUDO = 4096;
        public static final int NONELEC = 8192;
        public static final int CONMETAL = 16384;
        public static final int CONPOLY = 32768;
        public static final int CONDIFF = 65536;
        public static final int INTRANS = 0x400000;
        public static final Function UNKNOWN = new Function("unknown", "LFUNKNOWN", 0, 35, 0);
        public static final Function METAL1 = new Function("metal-1", "LFMETAL1", 1, 17, 0);
        public static final Function METAL2 = new Function("metal-2", "LFMETAL2", 2, 19, 0);
        public static final Function METAL3 = new Function("metal-3", "LFMETAL3", 3, 21, 0);
        public static final Function METAL4 = new Function("metal-4", "LFMETAL4", 4, 23, 0);
        public static final Function METAL5 = new Function("metal-5", "LFMETAL5", 5, 25, 0);
        public static final Function METAL6 = new Function("metal-6", "LFMETAL6", 6, 27, 0);
        public static final Function METAL7 = new Function("metal-7", "LFMETAL7", 7, 29, 0);
        public static final Function METAL8 = new Function("metal-8", "LFMETAL8", 8, 31, 0);
        public static final Function METAL9 = new Function("metal-9", "LFMETAL9", 9, 33, 0);
        public static final Function METAL10 = new Function("metal-10", "LFMETAL10", 10, 35, 0);
        public static final Function METAL11 = new Function("metal-11", "LFMETAL11", 11, 37, 0);
        public static final Function METAL12 = new Function("metal-12", "LFMETAL12", 12, 39, 0);
        public static final Function POLY1 = new Function("poly-1", "LFPOLY1", 1, 12, 0);
        public static final Function POLY2 = new Function("poly-2", "LFPOLY2", 2, 13, 0);
        public static final Function POLY3 = new Function("poly-3", "LFPOLY3", 3, 14, 0);
        public static final Function GATE = new Function("gate", "LFGATE", 0, 15, 0x400000);
        public static final Function DIFF = new Function("diffusion", "LFDIFF", 0, 11, 0);
        public static final Function DIFFP = new Function("p-diffusion", "LFDIFF", 0, 11, 64);
        public static final Function DIFFN = new Function("n-diffusion", "LFDIFF", 0, 11, 128);
        public static final Function IMPLANT = new Function("implant", "LFIMPLANT", 0, 2, 0);
        public static final Function IMPLANTP = new Function("p-implant", "LFIMPLANT", 0, 2, 64);
        public static final Function IMPLANTN = new Function("n-implant", "LFIMPLANT", 0, 2, 128);
        public static final Function CONTACT1 = new Function("contact-1", "LFCONTACT1", 0, 16, 0);
        public static final Function CONTACT2 = new Function("contact-2", "LFCONTACT2", 0, 18, 0);
        public static final Function CONTACT3 = new Function("contact-3", "LFCONTACT3", 0, 20, 0);
        public static final Function CONTACT4 = new Function("contact-4", "LFCONTACT4", 0, 22, 0);
        public static final Function CONTACT5 = new Function("contact-5", "LFCONTACT5", 0, 24, 0);
        public static final Function CONTACT6 = new Function("contact-6", "LFCONTACT6", 0, 26, 0);
        public static final Function CONTACT7 = new Function("contact-7", "LFCONTACT7", 0, 28, 0);
        public static final Function CONTACT8 = new Function("contact-8", "LFCONTACT8", 0, 30, 0);
        public static final Function CONTACT9 = new Function("contact-9", "LFCONTACT9", 0, 32, 0);
        public static final Function CONTACT10 = new Function("contact-10", "LFCONTACT10", 0, 34, 0);
        public static final Function CONTACT11 = new Function("contact-11", "LFCONTACT11", 0, 36, 0);
        public static final Function CONTACT12 = new Function("contact-12", "LFCONTACT12", 0, 38, 0);
        public static final Function PLUG = new Function("plug", "LFPLUG", 0, 40, 0);
        public static final Function OVERGLASS = new Function("overglass", "LFOVERGLASS", 0, 41, 0);
        public static final Function RESISTOR = new Function("resistor", "LFRESISTOR", 0, 4, 0);
        public static final Function CAP = new Function("capacitor", "LFCAP", 0, 5, 0);
        public static final Function TRANSISTOR = new Function("transistor", "LFTRANSISTOR", 0, 3, 0);
        public static final Function EMITTER = new Function("emitter", "LFEMITTER", 0, 6, 0);
        public static final Function BASE = new Function("base", "LFBASE", 0, 7, 0);
        public static final Function COLLECTOR = new Function("collector", "LFCOLLECTOR", 0, 8, 0);
        public static final Function SUBSTRATE = new Function("substrate", "LFSUBSTRATE", 0, 1, 0);
        public static final Function WELL = new Function("well", "LFWELL", 0, 0, 0);
        public static final Function WELLP = new Function("p-well", "LFWELL", 0, 0, 64);
        public static final Function WELLN = new Function("n-well", "LFWELL", 0, 0, 128);
        public static final Function GUARD = new Function("guard", "LFGUARD", 0, 9, 0);
        public static final Function ISOLATION = new Function("isolation", "LFISOLATION", 0, 10, 0);
        public static final Function BUS = new Function("bus", "LFBUS", 0, 42, 0);
        public static final Function ART = new Function("art", "LFART", 0, 43, 0);
        public static final Function CONTROL = new Function("control", "LFCONTROL", 0, 44, 0);

        private Function(String name, String constantName, int level, int height, int extraBits) {
            this.name = name;
            this.level = level;
            this.height = height;
            this.extraBits = extraBits;
        }

        public String toString() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public boolean isMetal() {
            return this == METAL1 || this == METAL2 || this == METAL3 || this == METAL4 || this == METAL5 || this == METAL6 || this == METAL7 || this == METAL8 || this == METAL9 || this == METAL10 || this == METAL11 || this == METAL12;
        }

        public boolean isDiff() {
            return this == DIFF || this == DIFFP || this == DIFFN;
        }

        public boolean isPoly() {
            return this == POLY1 || this == POLY2 || this == POLY3 || this == GATE;
        }

        public boolean isGatePoly() {
            return this.isPoly() && (this.extraBits & 0x400000) != 0;
        }

        public boolean isContact() {
            return this == CONTACT1 || this == CONTACT2 || this == CONTACT3 || this == CONTACT4 || this == CONTACT5 || this == CONTACT6 || this == CONTACT7 || this == CONTACT8 || this == CONTACT9 || this == CONTACT10 || this == CONTACT11 || this == CONTACT12;
        }

        public boolean isSubstrate() {
            return this == SUBSTRATE || this == WELL || this == WELLP || this == WELLN || this == IMPLANT || this == IMPLANTN || this == IMPLANTP;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

