/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DBMath
extends GenMath {
    private static double EPSILON = 0.01;

    public static boolean pointInRect(Point2D pt, Rectangle2D bounds) {
        double epsilon = EPSILON;
        if (pt.getX() < bounds.getMinX() - epsilon) {
            return false;
        }
        if (pt.getX() > bounds.getMaxX() + epsilon) {
            return false;
        }
        if (pt.getY() < bounds.getMinY() - epsilon) {
            return false;
        }
        return !(pt.getY() > bounds.getMaxY() + epsilon);
    }

    public static boolean doublesClose(double a, double b) {
        return Math.abs(a - b) < EPSILON;
    }

    public static boolean pointsClose(Point2D a, Point2D b) {
        return DBMath.doublesClose(a.getX(), b.getX()) && DBMath.doublesClose(a.getY(), b.getY());
    }

    public static boolean isOnLine(Point2D end1, Point2D end2, Point2D pt) {
        Point2D closestPointOnSegment = DBMath.closestPointToSegment(end1, end2, pt);
        return DBMath.pointsClose(closestPointOnSegment, pt);
    }
}

