#!/usr/bin/python2
## videocardDialog.py - A graphical kickstart file generator
## Copyright (C) 2001-2003 Red Hat, Inc.

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import gtk
import gobject
from rhpl.translate import _, N_,textdomain
#from rhpl.xhwstate import *
import string
import os
import rhpl

TRUE = 1
FALSE = 0

# begin cut'n'paste from old rhpxl.  should do this better...
drivers = {}

class VideoDriver:
#   driver   - the driver name
#   description - a human-readable description of what cards this driver is for
    def __str__ (self):
        return "%s - %s" % (self.driver, self.description)

    def __init__ (self, driver = None, description = None):
        self.description = description
        self.driver = driver

    def setDriver(self, driver):
        self.driver = driver
    
    def getDriver(self):
        return self.driver
    
    def setDescription(self, desc):
        self.description = desc
    
    def getDescription(self):
        return self.description

def readDrivers ():
    global drivers
    
    baseArch = rhpl.getArch()
    if baseArch in ("ia32e", "x86_64", "ppc64", "s390x", "sparc64"):
        libdir = 'lib64'
    else:
        libdir = 'lib'

    if os.access('/usr/share/hwdata/videodrivers', os.R_OK):
	db = open ('/usr/share/hwdata/videodrivers')
	lines = db.readlines()
	db.close()
	drivers = {}
	for line in lines:
	    line = string.strip(line)
	    if line[0] == '#':
		continue
	    if string.find(line,'\t') == -1:
		continue
	    ( driver, desc ) = string.splitfields (line, '\t', 1)
	    f = '/usr/%s/xorg/modules/drivers/%s_drv.so' % (libdir, driver)
	    if os.access(f, os.R_OK):
		drivers[driver] = VideoDriver(driver=driver, description=desc)
            
    # Add drivers that do exist that we don't have entries for.
    if os.access('/usr/%s/xorg/modules/drivers' % (libdir,) , os.R_OK):
        d = os.listdir('/usr/%s/xorg/modules/drivers' %(libdir,))

        for module in d:
            if module.endswith('_drv.so'):
                module = module.replace('_drv.so','')
                if module != 'dummy' and module != 'atimisc':
                    if not drivers.has_key(module):
                        drivers[module] = VideoDriver(driver = module, description = "Vendor-supplied driver for %s cards" % (module,))
# end pastings

class VideocardDialog:

    def __init__(self, xml, videocard, hardware_state):
        self.xml = xml
        self.videocard = videocard
        self.hardware_state = hardware_state
        self.probed_path = None
 
        xml.get_widget("videocard_icon").set_from_file("/usr/share/system-config-display/pixmaps/videocard.png")

        self.changing_selection = 0
        
        dialog = xml.get_widget("videocard_dialog")
        dialog.set_transient_for(xml.get_widget("display_dialog"))
        dialog.set_modal(TRUE)

        videocard_store = gtk.ListStore(gobject.TYPE_PYOBJECT)
        self.videocard_store = videocard_store

	readDrivers()
        driver_list = drivers.keys()
        driver_list.sort()

        default_driver = self.hardware_state.get_videocard_driver()

        for driver in driver_list:
            iter = videocard_store.append()
            videocard_store.set_value(iter, 0, drivers[driver])

            if driver == default_driver:
                self.probed_path = videocard_store.get_path(iter)

        self.tree_view = xml.get_widget("videocard_tree")
        self.tree_view.set_model(videocard_store)
        self.tree_view.set_direction(gtk.TEXT_DIR_LTR)
        selection = self.tree_view.get_selection()
        # Select the first before setting up callback, to avoid first callback.
        selection.select_iter(videocard_store.get_iter_first())
        selection.connect("changed", self.selection_changed)

        cell = gtk.CellRendererText()
        self.vc_col = gtk.TreeViewColumn(None, cell)
        self.vc_col.set_cell_data_func(cell, self.display)
        self.tree_view.append_column(self.vc_col)

        self.type_entry = xml.get_widget("videocard_type_entry")
        self.driver_entry = xml.get_widget("videocard_driver_entry")

        button = xml.get_widget("videocard_probe_button")
        button.connect("clicked", self.probe_videocard)
        primary = videocard.primaryCard()
        button.set_sensitive(primary != None)

        self.hydrate(self.hardware_state)

    def display(self, column, cell, model, iter):
	pyobj = model.get_value(iter, 0)
	cell.set_property('text', str(pyobj))
	return
    
    def goto_row(self, drivername):
        if not self.probed_path:
            #no point in trying to seek to the path if it doesn't exist
            return

        self.tree_view.expand_row(self.probed_path[0], TRUE)
        self.changing_selection = 1
        selection = self.tree_view.get_selection()
        iter = self.videocard_store.get_iter(self.probed_path)

        selection.select_iter(iter)
        self.changing_selection = 0
        self.tree_view.set_cursor(self.probed_path, self.vc_col, FALSE)
        self.tree_view.scroll_to_cell(self.probed_path, self.vc_col, TRUE, 0.5, 0.0)
        
    def set_card_data(self, driver_name, goto_row):
	driver = drivers[driver_name]
	if goto_row:
	    self.goto_row(driver)

    def probe_videocard(self, widget):
        if self.probed_path:
            self.goto_row(self.probed_path)

    def custom_mem_toggled(self, checkbutton):
        self.mem_optionmenu.set_sensitive(checkbutton.get_active())

    def selection_changed(self, selection):
        if self.changing_selection:
            return
        (store, iter) = selection.get_selected()
        if iter == None:
            return

    def hydrate(self, state):
        name = state.get_videocard_name()
        self.goto_row(name)

    def dehydrate(self, state):
        (store, iter) = self.tree_view.get_selection().get_selected()
        if iter == None:
            return
        driver = self.videocard_store.get_value(iter, 0)
        state.set_videocard_driver(driver.getDriver())
        
    def run(self):
        dialog = self.xml.get_widget("videocard_dialog")
        dialog.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
        dialog.present()
        while 1:
            res = dialog.run()
            
            if res != gtk.RESPONSE_OK:
                dialog.hide()
                return FALSE
            
            break
        
        dialog.hide()
        return TRUE
