/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.facesconfig.common.guiutils.SWTUtils;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.NullValueType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.EditValueDialog;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.editor.FormEditor;

public class EditListEntriesDialog
extends Dialog {
    private static final int MIN_DIALOG_WIDTH = 300;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private ClassButtonDialogField valueClassField;
    private IProject project;
    private TableViewer tableViewer;
    private Button removeButton;
    private Button editButton;
    private ListEntriesType listEntries;
    private AbstractFacesConfigSection section;
    static /* synthetic */ Class class$0;

    public EditListEntriesDialog(Shell parentShell, ListEntriesType listEntries, AbstractFacesConfigSection section) {
        super(parentShell);
        this.listEntries = listEntries;
        this.section = section;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Editing list-entries");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        container.setLayout((Layout)gl);
        this.createKeyValueSection(container);
        this.createTableSection(container);
        this.initFields();
        return container;
    }

    private void initFields() {
        if (this.listEntries.getValueClass() != null) {
            this.valueClassField.setText(this.listEntries.getValueClass().getTextContent());
        }
        this.tableViewer.setInput((Object)this.listEntries);
    }

    private void createKeyValueSection(Composite parent) {
        this.valueClassField = new ClassButtonDialogField(this.getProject());
        this.valueClassField.setLabelText(EditorMessages.InitializationSection_MapType_ValueClass);
        Composite typeSelectionSection = SWTUtils.createComposite((Composite)parent, (int)0);
        GridData gd = new GridData(768);
        typeSelectionSection.setLayoutData((Object)gd);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        typeSelectionSection.setLayout((Layout)gl);
        this.valueClassField.doFillIntoGrid(null, typeSelectionSection, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.valueClassField.getTextControl(null, parent));
    }

    private void createTableSection(Composite parent) {
        Composite mapValueSection = SWTUtils.createComposite((Composite)parent, (int)0);
        GridData gd = new GridData(1808);
        mapValueSection.setLayoutData((Object)gd);
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        mapValueSection.setLayout((Layout)gl);
        DialogFieldBase valuesTitle = new DialogFieldBase();
        valuesTitle.setLabelText(EditorMessages.InitializationSection_MapTable_Title);
        valuesTitle.doFillIntoGrid(null, mapValueSection, numberOfColumns);
        Table mapTable = new Table(mapValueSection, 68352);
        mapTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditListEntriesDialog.this.updateButtonsStatus();
            }
        });
        mapTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (((IStructuredSelection)EditListEntriesDialog.this.tableViewer.getSelection()).size() > 0) {
                    EditListEntriesDialog.this.editButtonSelected(null);
                }
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        mapTable.setLayoutData((Object)gd);
        mapTable.setHeaderVisible(true);
        mapTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        mapTable.setLayout((Layout)layout);
        TableColumn keyCol = new TableColumn(mapTable, 0);
        keyCol.setText(EditorMessages.InitializationSection_MapTable_Value);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        keyCol.setResizable(true);
        this.tableViewer = new TableViewer(mapTable);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FacesConfigPackage.eINSTANCE.getValueType().isInstance(element) || FacesConfigPackage.eINSTANCE.getNullValueType().isInstance(element);
            }
        });
        Composite operationContainer = null;
        operationContainer = SWTUtils.createComposite((Composite)mapValueSection, (int)0);
        gd = new GridData(1040);
        operationContainer.setLayoutData((Object)gd);
        gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        Button addButton = SWTUtils.createPushButton((Composite)operationContainer, (String)EditorMessages.UI_Button_Add_more);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        addButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditListEntriesDialog.this.addButtonSelected(e);
            }
        });
        this.editButton = SWTUtils.createPushButton((Composite)operationContainer, (String)EditorMessages.UI_Button_Edit_more);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditListEntriesDialog.this.editButtonSelected(e);
            }
        });
        this.removeButton = SWTUtils.createPushButton((Composite)operationContainer, (String)EditorMessages.UI_Button_Remove);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditListEntriesDialog.this.removeButtonSelected();
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private AdapterFactory getAdapterFactory() {
        return this.section.getAdapterFactory();
    }

    private void addButtonSelected(SelectionEvent e) {
        EditValueDialog dialog = new EditValueDialog(EditorPlugin.getActiveShell(), true, false, null);
        if (dialog.open() == 0) {
            if (dialog.isNullValue()) {
                NullValueType nullValue = FacesConfigFactory.eINSTANCE.createNullValueType();
                this.listEntries.getNullValue().add((Object)nullValue);
            } else {
                ValueType value = FacesConfigFactory.eINSTANCE.createValueType();
                value.setTextContent((String)dialog.getResultData());
                this.listEntries.getValue().add((Object)value);
            }
        }
    }

    private void editButtonSelected(SelectionEvent e) {
        boolean isNullValue;
        Object select = ((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        String valueText = null;
        if (select instanceof NullValueType) {
            isNullValue = true;
        } else {
            isNullValue = false;
            valueText = ((ValueType)select).getTextContent();
        }
        EditValueDialog dialog = new EditValueDialog(EditorPlugin.getActiveShell(), true, isNullValue, valueText);
        if (dialog.open() == 0) {
            if (isNullValue && !dialog.isNullValue()) {
                this.listEntries.getNullValue().remove(select);
                ValueType value = FacesConfigFactory.eINSTANCE.createValueType();
                value.setTextContent((String)dialog.getResultData());
                this.listEntries.getValue().add((Object)value);
            } else if (!isNullValue && dialog.isNullValue()) {
                this.listEntries.getValue().remove(select);
                NullValueType nullValue = FacesConfigFactory.eINSTANCE.createNullValueType();
                this.listEntries.getNullValue().add((Object)nullValue);
            } else if (!isNullValue && !dialog.isNullValue()) {
                ((ValueType)select).setTextContent((String)dialog.getResultData());
            }
        }
    }

    private void removeButtonSelected() {
        Object select = ((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        if (select instanceof NullValueType) {
            this.listEntries.getNullValue().remove(select);
        } else {
            this.listEntries.getValue().remove(select);
        }
        this.tableViewer.refresh();
        this.updateButtonsStatus();
    }

    public void updateButtonsStatus() {
        if (((IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    protected void okPressed() {
        String valueClass = this.valueClassField.getText();
        if (this.listEntries.getValueClass() != null) {
            this.listEntries.getValueClass().setTextContent(valueClass);
        } else {
            ValueClassType valueClassType = FacesConfigFactory.eINSTANCE.createValueClassType();
            valueClassType.setTextContent(valueClass);
            this.listEntries.setValueClass(valueClassType);
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(300), shellSize.x), shellSize.y);
    }

    public IProject getProject() {
        if (this.project == null) {
            FormEditor formEditor = this.section.getPage().getEditor();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.project = (IProject)formEditor.getAdapter((Class)clazz);
        }
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public ListEntriesType getListEntries() {
        return this.listEntries;
    }

    public void setListEntries(ListEntriesType listEntries) {
        this.listEntries = listEntries;
    }
}

