/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.provisional.symbols;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ISymbol;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ITypeDescriptor;
import org.eclipse.jst.jsf.designtime.internal.provisional.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.internal.provisional.context.IDTExternalContext;
import org.eclipse.jst.jsf.designtime.internal.provisional.symbols.DefaultBeanSymbolSourceProvider;
import org.eclipse.jst.jsf.designtime.internal.provisional.symbols.FileContextUtil;
import org.eclipse.jst.jsf.designtime.internal.provisional.symbols.SymbolUtil;

public class DefaultBuiltInSymbolProvider {
    private static DefaultBuiltInSymbolProvider INSTANCE;
    private static final String APPLICATION_SCOPE = "applicationScope";
    private static final String SESSION_SCOPE = "sessionScope";
    private static final String REQUEST_SCOPE = "requestScope";
    private static final String COOKIE_IMPLICIT_OBJ = "cookie";
    private static final String FACES_CONTEXT_IMPLICIT_OBJ = "facesContext";
    private static final String HEADER_IMPLICIT_OBJ = "header";
    private static final String HEADER_VALUES_IMPLICIT_OBJ = "headerValues";
    private static final String INIT_PARAM_IMPLICIT_OBJ = "initParam";
    private static final String PARAM_IMPLICIT_OBJ = "param";
    private static final String PARAM_VALUES_IMPLICIT_OBJ = "paramValues";
    private static final String VIEW_IMPLICIT_OBJ = "view";

    public static synchronized DefaultBuiltInSymbolProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultBuiltInSymbolProvider();
        }
        return INSTANCE;
    }

    protected DefaultBuiltInSymbolProvider() {
    }

    public ISymbol[] getSymbols(IAdaptable context, int symbolScopeMask) {
        IFile fileContext = FileContextUtil.deriveIFileFromContext(context);
        return this.getSymbolsForScope(fileContext, symbolScopeMask).toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    public ISymbol getSymbol(String name, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.findSymbolByName(this.getSymbols(context, symbolScopeMask), name);
    }

    public ISymbol[] getSymbols(String prefix, IAdaptable context, int symbolScopeMask) {
        return SymbolUtil.filterSymbolsByPrefix(this.getSymbols(context, symbolScopeMask), prefix);
    }

    private List getSymbolsForScope(IFile file, int symbolScopeMask) {
        ArrayList symbols = new ArrayList();
        if ((symbolScopeMask & 1) != 0) {
            symbols.addAll(this.getRequestScopeSymbols(file));
        }
        if ((symbolScopeMask & 2) != 0) {
            symbols.addAll(this.getSessionScopeSymbols(file));
        }
        if ((symbolScopeMask & 4) != 0) {
            symbols.addAll(this.getApplicationScopeSymbols(file));
        }
        return symbols;
    }

    private List getRequestScopeSymbols(IFile file) {
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        symbols.add(this.createScopeSymbol(file, 1, REQUEST_SCOPE));
        symbols.add(this.createUnresolvedMapSymbol(COOKIE_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(HEADER_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(HEADER_VALUES_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(PARAM_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(PARAM_VALUES_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(FACES_CONTEXT_IMPLICIT_OBJ));
        symbols.add(this.createUnresolvedMapSymbol(VIEW_IMPLICIT_OBJ));
        return symbols;
    }

    private List getSessionScopeSymbols(IFile file) {
        return Collections.singletonList(this.createScopeSymbol(file, 2, SESSION_SCOPE));
    }

    private List getApplicationScopeSymbols(IFile file) {
        ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
        symbols.add(this.createUnresolvedMapSymbol(INIT_PARAM_IMPLICIT_OBJ));
        symbols.add(this.createScopeSymbol(file, 4, APPLICATION_SCOPE));
        return symbols;
    }

    private ISymbol createScopeSymbol(IFile file, int scopeMask, String name) {
        ScopeMap mapSource = new ScopeMap(file, scopeMask);
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource((Map)mapSource);
        typeDesc.setImmutable(false);
        IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
        symbol.setName(name);
        symbol.setRuntimeSource(ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        return symbol;
    }

    private ISymbol createUnresolvedMapSymbol(String name) {
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource(Collections.EMPTY_MAP);
        IInstanceSymbol symbol = SymbolFactory.eINSTANCE.createIInstanceSymbol();
        symbol.setName(name);
        symbol.setRuntimeSource(ERuntimeSource.BUILT_IN_SYMBOL_LITERAL);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        return symbol;
    }

    private static class ScopeMap
    extends AbstractMap {
        private final IFile _externalContextKey;
        private final int _scopeMask;

        ScopeMap(IFile externalContextKey, int scopeMask) {
            this._externalContextKey = externalContextKey;
            this._scopeMask = scopeMask;
        }

        public Set entrySet() {
            HashMap<String, ISymbol> scopeMap = new HashMap<String, ISymbol>();
            DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(this._externalContextKey.getProject());
            DefaultBeanSymbolSourceProvider beanProvider = DefaultBeanSymbolSourceProvider.getInstance();
            ISymbol[] beanSymbols = beanProvider.getSymbols((IAdaptable)this._externalContextKey, this._scopeMask);
            int i = 0;
            while (i < beanSymbols.length) {
                scopeMap.put(beanSymbols[i].getName(), beanSymbols[i]);
                ++i;
            }
            IDTExternalContext externalContext = manager.getFacesContext(this._externalContextKey).getDTExternalContext((IAdaptable)this._externalContextKey);
            scopeMap.putAll(externalContext.getMapForScope(this._scopeMask));
            return scopeMap.entrySet();
        }
    }
}

