/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.provisional.el;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.internal.provisional.ISymbol;
import org.eclipse.jst.jsf.designtime.internal.provisional.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.provisional.context.IDTExternalContext;
import org.eclipse.jst.jsf.designtime.internal.provisional.el.AbstractDTVariableResolver;
import org.eclipse.jst.jsf.designtime.internal.provisional.symbols.DefaultBeanSymbolSourceProvider;
import org.eclipse.jst.jsf.designtime.internal.provisional.symbols.DefaultBuiltInSymbolProvider;

public class DefaultDTVariableResolver
extends AbstractDTVariableResolver {
    public ISymbol resolveVariable(DTFacesContext context, String name, IAdaptable externalContextKey) {
        DefaultBuiltInSymbolProvider builtins = DefaultBuiltInSymbolProvider.getInstance();
        ISymbol symbol = builtins.getSymbol(name, externalContextKey, 7);
        if (symbol != null) {
            return symbol;
        }
        IDTExternalContext externalContext = context.getDTExternalContext(externalContextKey);
        if (externalContext == null) {
            return null;
        }
        symbol = (ISymbol)externalContext.getRequestMap().get(name);
        if (symbol == null && (symbol = (ISymbol)externalContext.getSessionMap().get(name)) == null && (symbol = (ISymbol)externalContext.getApplicationMap().get(name)) == null) {
            DefaultBeanSymbolSourceProvider beanProvider = DefaultBeanSymbolSourceProvider.getInstance();
            symbol = beanProvider.getSymbol(name, externalContextKey, 7);
        }
        return symbol;
    }

    public ISymbol[] getAllVariables(DTFacesContext facesContext, IAdaptable externalContextKey) {
        ArrayList allSymbols = new ArrayList();
        this.addBuiltins(allSymbols, externalContextKey);
        IDTExternalContext externalContext = facesContext.getDTExternalContext(externalContextKey);
        if (externalContext != null) {
            this.addExternalContextSymbols(allSymbols, externalContext, externalContextKey);
        }
        this.addBeanSymbols(allSymbols, externalContextKey);
        return allSymbols.toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
    }

    private void addBuiltins(List list, IAdaptable externalContextKey) {
        DefaultBuiltInSymbolProvider builtins = DefaultBuiltInSymbolProvider.getInstance();
        list.addAll(Arrays.asList(builtins.getSymbols(externalContextKey, 7)));
    }

    private void addExternalContextSymbols(List list, IDTExternalContext externalContext, IAdaptable externalContextKey) {
        if (externalContext != null) {
            ISymbol[] externalContextSymbols = externalContext.getMapForScope(7).values().toArray(ISymbol.EMPTY_SYMBOL_ARRAY);
            list.addAll(Arrays.asList(externalContextSymbols));
        }
    }

    private void addBeanSymbols(List list, IAdaptable externalContextKey) {
        DefaultBeanSymbolSourceProvider beanProvider = DefaultBeanSymbolSourceProvider.getInstance();
        ISymbol[] beanSymbols = beanProvider.getSymbols(externalContextKey, 7);
        list.addAll(Arrays.asList(beanSymbols));
    }
}

