/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.examples.lwm2m;

import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.examples.lwm2m.tasks.FunctionBlockLeshanGeneratorTask;
import org.eclipse.vorto.codegen.examples.lwm2m.tasks.FunctionBlockXmlGeneratorTask;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class LWM2MGenerator
implements IVortoCodeGenerator {
    private static final String CONFIG_PARAM_SKIP_CLIENT = "skipClient";

    public IGenerationResult generate(InformationModel infomodel, InvocationContext context) {
        GenerationResultZip output = new GenerationResultZip(infomodel, this.getServiceKey());
        for (FunctionblockProperty fbProperty : infomodel.getProperties()) {
            new FunctionBlockXmlGeneratorTask().generate(fbProperty.getType(), context, (IGeneratedWriter)output);
            if (!context.getConfigurationProperties().getOrDefault(CONFIG_PARAM_SKIP_CLIENT, "false").equalsIgnoreCase("false")) continue;
            new FunctionBlockLeshanGeneratorTask().generate(fbProperty.getType(), context, (IGeneratedWriter)output);
        }
        return output;
    }

    public String getServiceKey() {
        return "lwm2m";
    }
}

