/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp;

import org.eclipse.gemini.web.tomcat.spi.WebBundleClassLoaderFactory;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.snaps.core.internal.Host;
import org.eclipse.virgo.snaps.core.internal.Snap;
import org.eclipse.virgo.snaps.core.internal.deployer.SnapFactory;
import org.eclipse.virgo.snaps.core.internal.webapp.WebAppSnap;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebAppSnapFactory
implements SnapFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Bundle snapBundle;
    private final WebBundleClassLoaderFactory classLoaderFactory;
    private final EventLogger eventLogger;
    private WebAppSnap webAppSnap;

    public WebAppSnapFactory(Bundle snapBundle, WebBundleClassLoaderFactory webBundleClassLoaderFactory, EventLogger eventLogger) {
        this.snapBundle = snapBundle;
        this.classLoaderFactory = webBundleClassLoaderFactory;
        this.eventLogger = eventLogger;
    }

    @Override
    public Snap createSnap(Host host) {
        this.logger.info("Creating new snap that binds snap bundle '{}' to host bundle '{}'", (Object)this.snapBundle, (Object)host.getBundle());
        this.webAppSnap = new WebAppSnap(host, this.snapBundle, this.classLoaderFactory, this.eventLogger);
        return this.webAppSnap;
    }

    @Override
    public boolean hasSnap() {
        return this.webAppSnap != null;
    }

    @Override
    public Snap getSnap() {
        return this.webAppSnap;
    }
}

