/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.eclipse.gemini.web.core.InstallationOptions;
import org.eclipse.gemini.web.core.WebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.url.PackageMergeUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParserFactory;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.osgi.framework.Version;

public final class SpecificationWebBundleManifestTransformer
implements WebBundleManifestTransformer {
    private static final char SLASH = '/';
    private static final int MINIMUM_VALID_BUNDLE_MANIFEST_VERSION = 2;

    @Override
    public void transform(BundleManifest manifest, URL sourceURL, InstallationOptions options, boolean webBundle) throws IOException {
        if (options == null) {
            options = new InstallationOptions(Collections.emptyMap());
        }
        this.transformBundleSymbolicName(manifest, options, webBundle);
        this.transformBundleVersion(manifest, options, webBundle);
        this.transformBundleManifestVersion(manifest, options, webBundle);
        this.transformBundleClassPath(manifest, options, webBundle);
        this.transformImportPackage(manifest, options, webBundle);
        this.transformExportPackage(manifest, options, webBundle);
        this.transformWebContextPath(manifest, options, webBundle);
    }

    private void transformExportPackage(BundleManifest manifest, InstallationOptions options, boolean isWebApplicationBundle) {
        String epd = options.getExportPackageDeclaration();
        if (epd != null) {
            if (isWebApplicationBundle) {
                throw new IllegalArgumentException("Export-Package URL parameter cannot modify a Web Application Bundle");
            }
            HeaderParser parser = HeaderParserFactory.newHeaderParser((ParserLogger)new TransformerParserLogger());
            List packageHeader = parser.parsePackageHeader(epd, "Export-Package");
            for (HeaderDeclaration headerDeclaration : packageHeader) {
                for (String name : headerDeclaration.getNames()) {
                    PackageMergeUtils.mergeExportPackage(manifest, name, headerDeclaration.getAttributes(), headerDeclaration.getDirectives());
                }
            }
        }
    }

    private void transformImportPackage(BundleManifest manifest, InstallationOptions options, boolean isWebApplicationBundle) {
        String ipd = options.getImportPackageDeclaration();
        if (ipd != null) {
            if (isWebApplicationBundle) {
                throw new IllegalArgumentException("Import-Package URL parameter cannot modify a Web Application Bundle");
            }
            HeaderParser parser = HeaderParserFactory.newHeaderParser((ParserLogger)new TransformerParserLogger());
            List packageHeader = parser.parsePackageHeader(ipd, "Import-Package");
            for (HeaderDeclaration headerDeclaration : packageHeader) {
                for (String name : headerDeclaration.getNames()) {
                    PackageMergeUtils.mergeImportPackage(manifest, name, headerDeclaration.getAttributes(), headerDeclaration.getDirectives());
                }
            }
        }
    }

    private void transformBundleSymbolicName(BundleManifest manifest, InstallationOptions options, boolean isWebApplicationBundle) {
        if (options.getBundleSymbolicName() != null) {
            if (isWebApplicationBundle) {
                throw new IllegalArgumentException("Bundle-SymbolicName URL parameter cannot modify a Web Application Bundle");
            }
            manifest.getBundleSymbolicName().setSymbolicName(options.getBundleSymbolicName());
        }
    }

    private void transformBundleManifestVersion(BundleManifest manifest, InstallationOptions options, boolean isWebApplicationBundle) {
        if (options.getBundleManifestVersion() != null) {
            if (isWebApplicationBundle) {
                throw new IllegalArgumentException("Bundle-ManifestVersion URL parameter cannot modify a Web Application Bundle");
            }
            manifest.setBundleManifestVersion(this.parseBundleManifestVersion(options.getBundleManifestVersion()));
        }
    }

    private int parseBundleManifestVersion(String bundleManifestVersion) {
        int result = 2;
        if (bundleManifestVersion != null) {
            try {
                result = Integer.parseInt(bundleManifestVersion);
                if (result < 2) {
                    throw new IllegalArgumentException("Bundle-ManifestVersion " + result + " is less than the smallest valid value of " + 2);
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Bundle-ManifestVersion is not a valid integer.", ex);
            }
        }
        return result;
    }

    private void transformBundleVersion(BundleManifest manifest, InstallationOptions options, boolean isWebApplicationBundle) {
        if (options.getBundleVersion() != null) {
            if (isWebApplicationBundle) {
                throw new IllegalArgumentException("Bundle-Version URL parameter cannot modify a Web Application Bundle");
            }
            manifest.setBundleVersion(new Version(options.getBundleVersion()));
        }
    }

    private void transformBundleClassPath(BundleManifest manifest, InstallationOptions options, boolean isWebApplicationBundle) {
        List bundleClassPath = manifest.getBundleClasspath();
        String bundleClassPathOption = options.getBundleClassPath();
        if (bundleClassPathOption != null) {
            if (isWebApplicationBundle) {
                throw new IllegalArgumentException("Bundle-ClassPath URL parameter cannot modify a Web Application Bundle");
            }
            String[] stringArray = SpecificationWebBundleManifestTransformer.parseBundleClassPath(bundleClassPathOption);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (!bundleClassPath.contains(entry)) {
                    bundleClassPath.add(entry);
                }
                ++n2;
            }
        }
    }

    private static String[] parseBundleClassPath(String bundleClassPath) {
        String[] bundleClassPathEntries = bundleClassPath.split(",");
        SpecificationWebBundleManifestTransformer.minimallyValidateBundleClassPathEntries(bundleClassPathEntries, bundleClassPath);
        return bundleClassPathEntries;
    }

    private static void minimallyValidateBundleClassPathEntries(String[] bundleClassPathEntries, String bundleClassPath) {
        int i = 0;
        while (i < bundleClassPathEntries.length) {
            String entry = bundleClassPathEntries[i];
            if (entry.length() == 0) {
                SpecificationWebBundleManifestTransformer.diagnoseInvalidEntry(entry, bundleClassPath);
            }
            if (entry.charAt(entry.length() - 1) == '/') {
                if (entry.length() == 1) {
                    SpecificationWebBundleManifestTransformer.diagnoseInvalidEntry(entry, bundleClassPath);
                }
                bundleClassPathEntries[i] = entry.substring(0, entry.length() - 1);
            }
            ++i;
        }
    }

    private static void diagnoseInvalidEntry(String entry, String bundleClassPath) {
        throw new IllegalArgumentException("Bundle-ClassPath'" + bundleClassPath + "' contains an invalid entry '" + entry + "'");
    }

    private void transformWebContextPath(BundleManifest manifest, InstallationOptions options, boolean isWebApplicationBundle) {
        String webContextPathHeader;
        String webContextPathOption = options.getWebContextPath();
        if (webContextPathOption != null) {
            manifest.setHeader("Web-ContextPath", this.validateWebContextPath(webContextPathOption));
        } else if (!(options.getDefaultWABHeaders() || (webContextPathHeader = manifest.getHeader("Web-ContextPath")) != null && webContextPathHeader.trim().length() != 0)) {
            throw new IllegalArgumentException("Web-ContextPath is missing");
        }
    }

    private String validateWebContextPath(String webContextPathOption) {
        String trimmedWebContextPathOption = webContextPathOption.trim();
        if (trimmedWebContextPathOption.length() == 0) {
            throw new IllegalArgumentException("Web-ContextPath URL parameter value is missing");
        }
        if (trimmedWebContextPathOption.charAt(0) == '/') {
            return trimmedWebContextPathOption;
        }
        return String.valueOf('/') + trimmedWebContextPathOption;
    }

    private static class TransformerParserLogger
    implements ParserLogger {
        private TransformerParserLogger() {
        }

        public String[] errorReports() {
            return null;
        }

        public void outputErrorMsg(Exception re, String item) {
        }
    }
}

