/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.kernel.deployer.core.internal.ApplicationRecoverer;
import org.eclipse.virgo.kernel.deployer.core.internal.BlockingAbortableSignal;
import org.eclipse.virgo.kernel.deployer.core.internal.ExistingNodeLocator;
import org.eclipse.virgo.kernel.deployer.core.internal.StandardDeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.core.internal.event.DeploymentListener;
import org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException;
import org.eclipse.virgo.kernel.deployer.model.GCRoots;
import org.eclipse.virgo.kernel.deployer.model.RuntimeArtifactModel;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactGraphInclosure;
import org.eclipse.virgo.kernel.install.artifact.PlanInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.AbstractInstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironmentFactory;
import org.eclipse.virgo.kernel.install.pipeline.Pipeline;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyBundleDependenciesException;
import org.eclipse.virgo.kernel.osgi.framework.UnableToSatisfyDependenciesException;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.KernelException;
import org.eclipse.virgo.nano.deployer.api.core.ApplicationDeployer;
import org.eclipse.virgo.nano.deployer.api.core.DeployUriNormaliser;
import org.eclipse.virgo.nano.deployer.api.core.DeployerConfiguration;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentOptions;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.WatchableRepository;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.io.PathReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

final class PipelinedApplicationDeployer
implements ApplicationDeployer,
ApplicationRecoverer {
    private static final String BUNDLE_TYPE = "bundle";
    private final EventLogger eventLogger;
    private final Object monitor = new Object();
    private final InstallEnvironmentFactory installEnvironmentFactory;
    private final InstallArtifactGraphInclosure installArtifactGraphInclosure;
    private final ArtifactIdentityDeterminer artifactIdentityDeterminer;
    private final RuntimeArtifactModel ram;
    private final DeploymentListener deploymentListener;
    private final Map<DeploymentIdentity, DeploymentOptions> deploymentOptionsMap = new HashMap<DeploymentIdentity, DeploymentOptions>();
    private final Pipeline pipeline;
    private final DeployUriNormaliser deployUriNormaliser;
    private final int deployerConfiguredTimeoutInSeconds;
    private final BundleContext bundleContext;

    public PipelinedApplicationDeployer(@NonNull Pipeline pipeline, @NonNull InstallArtifactGraphInclosure installArtifactGraphInclosure, @NonNull ArtifactIdentityDeterminer artifactIdentityDeterminer, @NonNull InstallEnvironmentFactory installEnvironmentFactory, @NonNull RuntimeArtifactModel ram, @NonNull DeploymentListener deploymentListener, @NonNull EventLogger eventLogger, @NonNull DeployUriNormaliser normaliser, @NonNull DeployerConfiguration deployerConfiguration, @NonNull BundleContext bundleContext) {
        this.eventLogger = eventLogger;
        this.installArtifactGraphInclosure = installArtifactGraphInclosure;
        this.artifactIdentityDeterminer = artifactIdentityDeterminer;
        this.installEnvironmentFactory = installEnvironmentFactory;
        this.ram = ram;
        this.deploymentListener = deploymentListener;
        this.deployUriNormaliser = normaliser;
        this.bundleContext = bundleContext;
        this.pipeline = pipeline;
        this.deployerConfiguredTimeoutInSeconds = deployerConfiguration.getDeploymentTimeoutSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity deploy(URI location) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            return this.deploy(location, new DeploymentOptions());
        }
    }

    private URI normaliseDeploymentUri(URI uri) throws DeploymentException {
        URI normalisedLocation = this.deployUriNormaliser.normalise(uri);
        if (normalisedLocation == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{uri, uri.getScheme()});
            throw new DeploymentException("PipelinedApplicationDeployer.deploy does not support '" + uri.getScheme() + "' scheme URIs");
        }
        return normalisedLocation;
    }

    public DeploymentIdentity install(URI location) throws DeploymentException {
        return this.install(location, new DeploymentOptions());
    }

    public DeploymentIdentity install(URI uri, DeploymentOptions deploymentOptions) throws DeploymentException {
        URI normalisedUri = this.normaliseDeploymentUri(uri);
        DeploymentIdentity deploymentIdentity = this.doInstall(normalisedUri, deploymentOptions);
        this.deploymentListener.deployed(normalisedUri, deploymentOptions);
        return deploymentIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentIdentity doInstall(URI normalisedUri, DeploymentOptions deploymentOptions) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            DeploymentIdentity deploymentIdentity;
            GraphNode<InstallArtifact> installNode;
            DeploymentIdentity refreshedIdentity;
            InstallArtifact existingArtifact = this.ram.get(normalisedUri);
            if (existingArtifact != null && (refreshedIdentity = this.refreshExistingArtifact(normalisedUri, existingArtifact)) != null) {
                return refreshedIdentity;
            }
            boolean shared = false;
            try {
                ArtifactIdentity artifactIdentity = this.determineIdentity(normalisedUri);
                installNode = this.findSharedNode(artifactIdentity);
                if (installNode == null) {
                    installNode = this.installArtifactGraphInclosure.constructGraphNode(artifactIdentity, new File(normalisedUri), null, null);
                } else {
                    shared = true;
                }
            }
            catch (Exception e) {
                throw new DeploymentException(String.valueOf(e.getMessage()) + ": uri='" + normalisedUri + "'", (Throwable)e);
            }
            try {
                deploymentIdentity = this.addGraphToModel(normalisedUri, installNode);
            }
            catch (KernelException ke) {
                if (!shared) {
                    this.destroyInstallGraph(installNode);
                }
                throw new DeploymentException(ke.getMessage(), (Throwable)ke);
            }
            if (!shared) {
                this.deploymentOptionsMap.put(deploymentIdentity, deploymentOptions);
                try {
                    this.driveInstallPipeline(normalisedUri, installNode);
                }
                catch (DeploymentException de) {
                    this.removeFromModel(deploymentIdentity);
                    this.destroyInstallGraph(installNode);
                    throw de;
                }
                catch (RuntimeException re) {
                    this.removeFromModel(deploymentIdentity);
                    this.destroyInstallGraph(installNode);
                    throw re;
                }
            }
            return deploymentIdentity;
        }
    }

    private ArtifactIdentity determineIdentity(URI artifactUri) throws DeploymentException {
        try {
            File artifact = new File(artifactUri);
            if (!artifact.exists()) {
                throw new DeploymentException(artifact + " does not exist");
            }
            return this.determineIdentity(artifact, null);
        }
        catch (Exception e) {
            throw new DeploymentException(String.valueOf(e.getMessage()) + ": uri='" + artifactUri + "'", (Throwable)e);
        }
    }

    private GraphNode<InstallArtifact> findSharedNode(ArtifactIdentity artifactIdentity) {
        GCRoots gcRoots = (GCRoots)((Object)this.ram);
        return ExistingNodeLocator.findSharedNode(gcRoots, artifactIdentity);
    }

    private void destroyInstallGraph(GraphNode<InstallArtifact> installGraph) throws DeploymentException {
        ((InstallArtifact)installGraph.getValue()).uninstall();
    }

    private void removeFromModel(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        this.ram.delete(deploymentIdentity);
    }

    private DeploymentIdentity refreshExistingArtifact(URI normalisedLocation, InstallArtifact existingArtifact) throws DeploymentException {
        String oldType = existingArtifact.getType();
        String oldName = existingArtifact.getName();
        Version oldVersion = existingArtifact.getVersion();
        DeploymentIdentity deploymentIdentity = this.refreshArtifact(normalisedLocation, existingArtifact);
        if (deploymentIdentity != null) {
            return deploymentIdentity;
        }
        StandardDeploymentIdentity oldDeploymentIdentity = new StandardDeploymentIdentity(oldType, oldName, oldVersion.toString());
        this.undeployInternal(oldDeploymentIdentity, true, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity deploy(URI location, DeploymentOptions deploymentOptions) throws DeploymentException {
        InstallArtifact installedArtifact;
        DeploymentIdentity deploymentIdentity;
        URI normalisedLocation = this.normaliseDeploymentUri(location);
        Object object = this.monitor;
        synchronized (object) {
            deploymentIdentity = this.install(location, deploymentOptions);
            installedArtifact = this.ram.get(normalisedLocation);
        }
        try {
            this.start(installedArtifact, deploymentOptions.getSynchronous());
        }
        catch (DeploymentException de) {
            Object object2 = this.monitor;
            synchronized (object2) {
                this.stopArtifact(installedArtifact);
                this.uninstallArtifact(installedArtifact);
            }
            throw de;
        }
        this.deploymentListener.deployed(normalisedLocation, deploymentOptions);
        return deploymentIdentity;
    }

    private DeploymentIdentity refreshArtifact(URI location, InstallArtifact installArtifact) throws DeploymentException {
        StandardDeploymentIdentity deploymentIdentity = null;
        if (installArtifact.refresh()) {
            this.deploymentListener.refreshed(location);
            deploymentIdentity = new StandardDeploymentIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString());
        }
        return deploymentIdentity;
    }

    public DeploymentIdentity deploy(String type, String name, Version version) throws DeploymentException {
        throw new UnsupportedOperationException("PipelinedApplicationDeployer ApplicationDeployer does not support deployment by type, name, and version");
    }

    public DeploymentIdentity deploy(String type, String name, Version version, DeploymentOptions options) throws DeploymentException {
        throw new UnsupportedOperationException("PipelinedApplicationDeployer ApplicationDeployer does not support deployment by type, name, and version");
    }

    private DeploymentIdentity addGraphToModel(URI location, GraphNode<InstallArtifact> installGraph) throws DuplicateFileNameException, DuplicateLocationException, DuplicateDeploymentIdentityException, DeploymentException {
        InstallArtifact installArtifact = (InstallArtifact)installGraph.getValue();
        ((AbstractInstallArtifact)installArtifact).setTopLevelDeployed();
        return this.ram.add(location, installArtifact);
    }

    @Override
    public void recoverDeployment(URI uri, DeploymentOptions options) throws DeploymentException {
        GraphNode<InstallArtifact> installNode = null;
        boolean shared = false;
        File artifact = new File(uri);
        if (options.getRecoverable() && (!options.getDeployerOwned() || artifact.exists())) {
            ArtifactIdentity artifactIdentity = this.determineIdentity(artifact, null);
            installNode = this.findSharedNode(artifactIdentity);
            if (installNode == null) {
                installNode = this.installArtifactGraphInclosure.recoverInstallGraph(artifactIdentity, artifact);
            } else {
                shared = true;
            }
        }
        if (installNode == null) {
            this.deploymentListener.undeployed(uri);
        } else {
            if (!shared) {
                this.driveInstallPipeline(uri, installNode);
                this.start((InstallArtifact)installNode.getValue(), options.getSynchronous());
            }
            try {
                this.addGraphToModel(uri, installNode);
            }
            catch (KernelException e) {
                throw new DeploymentException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ArtifactIdentity determineIdentity(File file, String scopeName) throws DeploymentException {
        ArtifactIdentity artifactIdentity = this.artifactIdentityDeterminer.determineIdentity(file, scopeName);
        if (artifactIdentity == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.INDETERMINATE_ARTIFACT_TYPE, new Object[]{file});
            throw new DeploymentException("Cannot determine the artifact identity of the file '" + file + "'");
        }
        return artifactIdentity;
    }

    private void driveInstallPipeline(URI uri, GraphNode<InstallArtifact> installGraph) throws DeploymentException {
        this.refreshWatchedRepositories();
        InstallEnvironment installEnvironment = this.installEnvironmentFactory.createInstallEnvironment((InstallArtifact)installGraph.getValue());
        try {
            try {
                this.pipeline.process(installGraph, installEnvironment);
            }
            catch (UnableToSatisfyBundleDependenciesException utsbde) {
                this.logDependencySatisfactionException(uri, (UnableToSatisfyDependenciesException)((Object)utsbde));
                throw new DeploymentException("Dependency satisfaction failed", (Throwable)utsbde);
            }
        }
        finally {
            installEnvironment.destroy();
        }
    }

    private void logDependencySatisfactionException(URI uri, UnableToSatisfyDependenciesException ex) {
        this.eventLogger.log((LogEvent)DeployerLogEvents.UNABLE_TO_SATISFY_CONSTRAINTS, (Throwable)ex, new Object[]{uri, ex.getSymbolicName(), ex.getVersion(), ex.getFailureDescription()});
    }

    private void start(InstallArtifact installArtifact, boolean synchronous) throws DeploymentException {
        BlockingAbortableSignal blockingSignal = new BlockingAbortableSignal(synchronous);
        installArtifact.start(blockingSignal);
        if (synchronous && this.deployerConfiguredTimeoutInSeconds > 0) {
            boolean complete = blockingSignal.awaitCompletion(this.deployerConfiguredTimeoutInSeconds);
            if (blockingSignal.isAborted()) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.START_ABORTED, new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), this.deployerConfiguredTimeoutInSeconds});
            } else if (!complete) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.START_TIMED_OUT, new Object[]{installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion(), this.deployerConfiguredTimeoutInSeconds});
            }
        } else {
            blockingSignal.checkComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity[] getDeploymentIdentities() {
        Object object = this.monitor;
        synchronized (object) {
            return this.ram.getDeploymentIdentities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity getDeploymentIdentity(URI location) {
        Object object = this.monitor;
        synchronized (object) {
            InstallArtifact installArtifact = this.ram.get(location);
            if (installArtifact != null) {
                return this.getDeploymentIdentity(installArtifact);
            }
        }
        return null;
    }

    private DeploymentIdentity getDeploymentIdentity(InstallArtifact installArtifact) {
        return new StandardDeploymentIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeployed(URI location) {
        URI normalisedLocation;
        try {
            normalisedLocation = this.deployUriNormaliser.normalise(location);
        }
        catch (DeploymentException deploymentException) {
            return false;
        }
        if (normalisedLocation == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{location.toString(), location.getScheme()});
            return false;
        }
        Object object = this.monitor;
        synchronized (object) {
            return this.ram.get(normalisedLocation) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentIdentity refresh(URI location, String symbolicName) throws DeploymentException {
        DeploymentIdentity deploymentIdentity;
        URI normalisedLocation = this.deployUriNormaliser.normalise(location);
        if (normalisedLocation == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.UNSUPPORTED_URI_SCHEME, new Object[]{location.toString(), location.getScheme()});
            throw new DeploymentException("PipelinedApplicationDeployer.refresh does not support '" + location.getScheme() + "' scheme URIs");
        }
        Object object = this.monitor;
        synchronized (object) {
            DeploymentIdentity originalDeploymentIdentity;
            InstallArtifact installArtifact = this.ram.get(normalisedLocation);
            if (installArtifact == null) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_URI_NOT_FOUND, new Object[]{location.toString()});
                throw new DeploymentException("Refresh not possible as no application is deployed from URI " + location);
            }
            deploymentIdentity = originalDeploymentIdentity = this.getDeploymentIdentity(installArtifact);
            try {
                if (this.refreshInternal(symbolicName, installArtifact)) {
                    this.deploymentListener.refreshed(normalisedLocation);
                } else {
                    DeploymentOptions deploymentOptions = this.deploymentOptionsMap.get(deploymentIdentity);
                    if (deploymentOptions == null) {
                        deploymentOptions = DeploymentOptions.DEFAULT_DEPLOYMENT_OPTIONS;
                    }
                    deploymentIdentity = this.redeploy(originalDeploymentIdentity, normalisedLocation, deploymentOptions);
                }
                this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_COMPLETED, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
            }
            catch (RuntimeException e) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_FAILED, (Throwable)e, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
                throw e;
            }
            catch (Exception e) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_REQUEST_FAILED, (Throwable)e, new Object[]{symbolicName, originalDeploymentIdentity.getType(), originalDeploymentIdentity.getSymbolicName(), originalDeploymentIdentity.getVersion()});
                throw new DeploymentException("refresh failed", (Throwable)e);
            }
        }
        return deploymentIdentity;
    }

    private boolean refreshInternal(String symbolicName, InstallArtifact installArtifact) throws DeploymentException {
        if (installArtifact instanceof PlanInstallArtifact) {
            return ((PlanInstallArtifact)installArtifact).refresh(symbolicName);
        }
        return installArtifact.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentIdentity redeploy(DeploymentIdentity toUndeploy, URI toDeploy, DeploymentOptions deploymentOptions) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            this.undeployInternal(toUndeploy, true, false);
        }
        return this.deploy(toDeploy, deploymentOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshBundle(String bundleSymbolicName, String bundleVersion) throws DeploymentException {
        InstallArtifact bundleInstallArtifact;
        StandardDeploymentIdentity deploymentIdentity = new StandardDeploymentIdentity(BUNDLE_TYPE, bundleSymbolicName, bundleVersion);
        Object object = this.monitor;
        synchronized (object) {
            bundleInstallArtifact = this.ram.get(deploymentIdentity);
        }
        if (bundleInstallArtifact == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_ARTEFACT_NOT_FOUND, new Object[]{BUNDLE_TYPE, bundleSymbolicName, bundleVersion});
            throw new DeploymentException("Refresh not possible as no bundle with name " + bundleSymbolicName + " and version " + bundleVersion + " is deployed");
        }
        bundleInstallArtifact.refresh();
    }

    public void undeploy(String symbolicName, String version) throws DeploymentException {
        DeploymentException de = null;
        try {
            this.undeploy(BUNDLE_TYPE, symbolicName, version);
            return;
        }
        catch (DeploymentException e) {
            de = e;
            try {
                this.undeploy("par", symbolicName, version);
                return;
            }
            catch (DeploymentException e2) {
                de = e2;
                try {
                    this.undeploy("plan", symbolicName, version);
                    return;
                }
                catch (DeploymentException e3) {
                    de = e3;
                    try {
                        this.undeploy("properties", symbolicName, version);
                        return;
                    }
                    catch (DeploymentException e4) {
                        de = e4;
                        throw de;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String type, String symbolicName, String version) throws DeploymentException {
        StandardDeploymentIdentity deploymentIdentity = new StandardDeploymentIdentity(type, symbolicName, version);
        Object object = this.monitor;
        synchronized (object) {
            this.undeployInternal(deploymentIdentity, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            this.undeployInternal(deploymentIdentity, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentIdentity deploymentIdentity, boolean deleted) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            this.undeployInternal(deploymentIdentity, false, true);
        }
    }

    private void undeployInternal(DeploymentIdentity deploymentIdentity, boolean redeploying, boolean deleted) throws DeploymentException {
        DeploymentOptions options = this.deploymentOptionsMap.remove(deploymentIdentity);
        URI location = this.doUndeploy(deploymentIdentity);
        if (location != null && !redeploying) {
            this.deleteArtifactIfNecessary(location, options, deleted);
        }
    }

    private void deleteArtifactIfNecessary(URI location, DeploymentOptions options, boolean deleted) {
        if (options != null && options.getDeployerOwned() && !deleted) {
            new PathReference(location).delete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI doUndeploy(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            InstallArtifact installArtifact = this.ram.get(deploymentIdentity);
            if (installArtifact == null) {
                String type = deploymentIdentity.getType();
                String symbolicName = deploymentIdentity.getSymbolicName();
                String version = deploymentIdentity.getVersion();
                this.eventLogger.log((LogEvent)DeployerLogEvents.UNDEPLOY_ARTEFACT_NOT_FOUND, new Object[]{type, symbolicName, version});
                throw new DeploymentException("Undeploy not possible as no " + type + " with name " + symbolicName + " and version " + version + " is deployed");
            }
            URI location = this.ram.getLocation(deploymentIdentity);
            this.ram.delete(deploymentIdentity);
            this.stopArtifact(installArtifact);
            this.uninstallArtifact(installArtifact);
            return location;
        }
    }

    private void stopArtifact(InstallArtifact installArtifact) throws DeploymentException {
        installArtifact.stop();
    }

    private void uninstallArtifact(InstallArtifact installArtifact) throws DeploymentException {
        installArtifact.uninstall();
    }

    private void refreshWatchedRepositories() {
        try {
            Collection references = this.bundleContext.getServiceReferences(WatchableRepository.class, null);
            for (ServiceReference reference : references) {
                WatchableRepository watchableRepository = (WatchableRepository)this.bundleContext.getService(reference);
                try {
                    watchableRepository.forceCheck();
                }
                catch (Exception exception) {
                    String name = watchableRepository instanceof Repository ? ((Repository)watchableRepository).getName() : "unknown repository type";
                    this.eventLogger.log((LogEvent)DeployerLogEvents.WATCHED_REPOSITORY_REFRESH_FAILED, new Object[]{name});
                }
                this.bundleContext.ungetService(reference);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.WATCHED_REPOSITORIES_REFRESH_FAILED, new Object[0]);
        }
    }

    public DeploymentIdentity[] bulkDeploy(List<URI> arg0, DeploymentOptions arg1) throws DeploymentException {
        throw new UnsupportedOperationException();
    }
}

