/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.tomcat.support;

import java.net.InetAddress;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.util.io.NetUtils;
import org.eclipse.virgo.web.tomcat.support.TomcatLogEvents;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public final class ServerLifecycleLoggingListener
implements LifecycleListener {
    private final EventLogger eventLogger;

    public ServerLifecycleLoggingListener() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.eventLogger = (EventLogger)bundleContext.getService(bundleContext.getServiceReference(EventLogger.class.getName()));
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Object source = event.getSource();
        if (source instanceof Server) {
            this.handleServerLifecycle((Server)source, event);
        } else if (source instanceof Service) {
            this.handleServiceLifecycle((Service)source, event);
        } else if (source instanceof Connector) {
            this.handleConnectorLifecycle((Connector)source, event);
        }
    }

    private void handleConnectorLifecycle(Connector source, LifecycleEvent event) {
        String type = event.getType();
        if ("start".equals(type)) {
            this.eventLogger.log((LogEvent)TomcatLogEvents.CREATING_CONNECTOR, new Object[]{source.getProtocol(), source.getScheme(), source.getPort()});
        }
    }

    private void handleServiceLifecycle(Service service, LifecycleEvent event) {
        Connector[] connectors;
        String type = event.getType();
        Connector[] connectorArray = connectors = service.findConnectors();
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            Connector connector = connectorArray[n2];
            if ("before_start".equals(type)) {
                connector.addLifecycleListener((LifecycleListener)this);
            } else if ("after_stop".equals(type)) {
                connector.removeLifecycleListener((LifecycleListener)this);
            }
            ++n2;
        }
    }

    private void handleServerLifecycle(Server server, LifecycleEvent event) {
        String type = event.getType();
        if ("before_start".equals(type)) {
            this.eventLogger.log((LogEvent)TomcatLogEvents.STARTING_TOMCAT, new Object[0]);
        } else if ("after_start".equals(type)) {
            this.eventLogger.log((LogEvent)TomcatLogEvents.TOMCAT_STARTED, new Object[0]);
        } else if ("before_stop".equals(type)) {
            this.eventLogger.log((LogEvent)TomcatLogEvents.STOPPING_TOMCAT, new Object[0]);
        } else if ("after_stop".equals(type)) {
            this.eventLogger.log((LogEvent)TomcatLogEvents.TOMCAT_STOPPED, new Object[0]);
        }
        Service[] services = server.findServices();
        if ("before_init".equals(type)) {
            this.checkConnectorPortsAvailable(services);
        }
        this.propagateListeners(event, services);
    }

    private void checkConnectorPortsAvailable(Service[] services) {
        Service[] serviceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            Connector[] connectors;
            Service service = serviceArray[n2];
            Connector[] connectorArray = connectors = service.findConnectors();
            int n3 = connectors.length;
            int n4 = 0;
            while (n4 < n3) {
                Connector connector = connectorArray[n4];
                this.checkPortAvailability(connector);
                ++n4;
            }
            ++n2;
        }
    }

    private void propagateListeners(LifecycleEvent event, Service[] services) {
        String type = event.getType();
        Service[] serviceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            Service service = serviceArray[n2];
            if ("before_start".equals(type)) {
                service.addLifecycleListener((LifecycleListener)this);
            } else if ("after_stop".equals(type)) {
                service.removeLifecycleListener((LifecycleListener)this);
            }
            ++n2;
        }
    }

    private void checkPortAvailability(Connector connector) {
        String hostName;
        Object address = connector.getProperty("address");
        String string = hostName = address != null ? ((InetAddress)address).getHostAddress() : null;
        if (hostName == null) {
            if (!NetUtils.isPortAvailable((int)connector.getPort())) {
                this.eventLogger.log((LogEvent)TomcatLogEvents.PORT_IN_USE, new Object[]{connector.getPort()});
                System.exit(-1);
            }
        } else if (!NetUtils.isPortAvailable((String)hostName, (int)connector.getPort())) {
            this.eventLogger.log((LogEvent)TomcatLogEvents.PORT_IN_USE, new Object[]{connector.getPort(), hostName});
            System.exit(-1);
        }
    }
}

