/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.dmfragment.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.gemini.blueprint.service.importer.support.ImportContextClassLoaderEnum;
import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceProxyFactoryBean;
import org.eclipse.virgo.kernel.dmfragment.ModuleBeanFactoryPostProcessor;
import org.osgi.framework.BundleContext;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

final class ContextClassLoaderPostProcessor
implements ModuleBeanFactoryPostProcessor {
    private static final String PROPERTY_CONTEXT_CLASS_LOADER = "importContextClassLoader";
    private static final Set<String> IMPORTER_CLASS_NAMES = ContextClassLoaderPostProcessor.createImportClassNames();

    ContextClassLoaderPostProcessor() {
    }

    @Override
    public void postProcess(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) {
        String[] beanDefinitionNames;
        String[] stringArray = beanDefinitionNames = beanFactory.getBeanDefinitionNames();
        int n = beanDefinitionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name);
            if (this.isServiceImportDefinition(beanDefinition)) {
                MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
                propertyValues.addPropertyValue(PROPERTY_CONTEXT_CLASS_LOADER, (Object)ImportContextClassLoaderEnum.UNMANAGED);
            }
            ++n2;
        }
    }

    private static Set<String> createImportClassNames() {
        HashSet<String> names = new HashSet<String>();
        names.add(OsgiServiceProxyFactoryBean.class.getName());
        names.add(OsgiServiceCollectionProxyFactoryBean.class.getName());
        return names;
    }

    private boolean isServiceImportDefinition(BeanDefinition beanDefinition) {
        return IMPORTER_CLASS_NAMES.contains(beanDefinition.getBeanClassName());
    }
}

