/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.object;

import java.lang.reflect.Array;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jolokia.converter.object.OpenTypeConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayTypeConverter
extends OpenTypeConverter<ArrayType> {
    ArrayTypeConverter(OpenTypeConverter pDispatcher) {
        super(pDispatcher);
    }

    @Override
    public boolean canConvert(OpenType pType) {
        return pType instanceof ArrayType;
    }

    @Override
    public Object convertToObject(ArrayType type, Object pFrom) {
        JSONAware value = this.toJSON(pFrom);
        if (!(value instanceof JSONArray)) {
            throw new IllegalArgumentException("Can not convert " + value + " to type " + type + " because JSON object type " + value.getClass() + " is not a JSONArray");
        }
        JSONArray jsonArray = (JSONArray)value;
        OpenType<?> elementOpenType = type.getElementOpenType();
        Object[] valueArray = this.createTargetArray(elementOpenType, jsonArray.size());
        int i = 0;
        for (Object element : jsonArray) {
            valueArray[i++] = this.getDispatcher().convertToObject(elementOpenType, element);
        }
        return valueArray;
    }

    private Object[] createTargetArray(OpenType pElementType, int pLength) {
        if (pElementType instanceof SimpleType) {
            try {
                SimpleType simpleType = (SimpleType)pElementType;
                Class<?> elementClass = Class.forName(simpleType.getClassName());
                return (Object[])Array.newInstance(elementClass, pLength);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Can't find class " + pElementType.getClassName() + " for instantiating array: " + e.getMessage(), e);
            }
        }
        if (pElementType instanceof CompositeType) {
            return new CompositeData[pLength];
        }
        throw new UnsupportedOperationException("Unsupported array element type: " + pElementType);
    }
}

