/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.parsing;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.virgo.shell.internal.parsing.ParsedCommand;
import org.eclipse.virgo.util.common.StringUtils;

public class ParsingUtils {
    private static final String DELIMITER = " ";
    private static final String EMPTY_STRING = "";

    public static ParsedCommand parseCommand(CharSequence command) {
        String commandString = command.toString();
        String[] tokens = StringUtils.tokenizeToStringArray((String)commandString, (String)DELIMITER);
        if (tokens.length == 0) {
            return null;
        }
        String commandName = tokens[0];
        String[] arguments = ParsingUtils.getArguments(commandString.substring(commandName.length()));
        return new ParsedCommand(commandName, arguments);
    }

    private static String[] getArguments(String buffer) {
        ArrayList<String> arguments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(buffer, DELIMITER, true);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (DELIMITER.equals(token)) {
                if (tokenizer.hasMoreElements()) continue;
                arguments.add(EMPTY_STRING);
                continue;
            }
            arguments.add(token);
        }
        return arguments.toArray(new String[arguments.size()]);
    }
}

