/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.formatting;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.module.ModuleContext;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.shell.internal.formatting.InstallArtifactCommandFormatter;
import org.eclipse.virgo.shell.internal.util.QuasiBundleUtil;
import org.eclipse.virgo.shell.internal.util.QuasiServiceUtil;
import org.eclipse.virgo.shell.internal.util.ServiceHolder;
import org.eclipse.virgo.util.common.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class BundleInstallArtifactCommandFormatter
implements InstallArtifactCommandFormatter<ManageableArtifact> {
    private static final int MAX_LINE_LENGTH = 80;
    private static final String ID_COLUMN_NAME = "Id";
    private static final int ID_COLUMN_MIN_WIDTH = "Id".length();
    private static final String SPRING_POWERED_COLUMN_NAME = " ";
    private static final int SPRING_POWERED_COLUMN_WIDTH = " ".length();
    private static final String NAME_COLUMN_NAME = "Name";
    private static final int NAME_COLUMN_MIN_WIDTH = "Name".length();
    private static final String VERSION_COLUMN_NAME = "Version";
    private static final int VERSION_COLUMN_MIN_WIDTH = "Version".length();
    private static final String STATE_COLUMN_NAME = "State";
    private static final String USER_REGION_NAME = "org.eclipse.virgo.region.user";
    private static final int STATE_COLUMN_MIN_WIDTH = 11;
    private final ModuleContextAccessor moduleContextAccessor;
    private final Region userRegion;
    private final QuasiBundleUtil quasiBundleUtil;
    private QuasiServiceUtil quasiServiceUtil;

    public BundleInstallArtifactCommandFormatter(RegionDigraph regionDigraph, QuasiBundleUtil quasiBundleUtil, QuasiServiceUtil quasiServiceUtil, ModuleContextAccessor moduleContextAccessor) {
        this.quasiBundleUtil = quasiBundleUtil;
        this.quasiServiceUtil = quasiServiceUtil;
        this.moduleContextAccessor = moduleContextAccessor;
        this.userRegion = regionDigraph.getRegion(USER_REGION_NAME);
    }

    @Override
    public List<String> formatList(List<ManageableArtifact> artifacts) {
        List<ArtifactHolder> artifactHolders = this.getArtifactHolders(artifacts);
        Collections.sort(artifactHolders);
        int maxIdLength = ID_COLUMN_MIN_WIDTH;
        int maxNameLength = NAME_COLUMN_MIN_WIDTH;
        int maxVersionLength = VERSION_COLUMN_MIN_WIDTH;
        for (ArtifactHolder artifact : artifactHolders) {
            int idLength = artifact.getId().toString().length();
            maxIdLength = idLength > maxIdLength ? idLength : maxIdLength;
            int nameLength = artifact.getName().length();
            maxNameLength = nameLength > maxNameLength ? nameLength : maxNameLength;
            int versionLength = artifact.getVersion().length();
            int n = maxVersionLength = versionLength > maxVersionLength ? versionLength : maxVersionLength;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int stateLength = 80 - (4 + maxIdLength + SPRING_POWERED_COLUMN_WIDTH + maxNameLength + maxVersionLength);
        if (stateLength < 11) {
            stateLength = 11;
        }
        String singleLineFormat = String.format("%%-%ds %%s %%-%ds %%-%ds %%%ds", maxIdLength, maxNameLength, maxVersionLength, stateLength);
        lines.add(String.format(singleLineFormat, ID_COLUMN_NAME, SPRING_POWERED_COLUMN_NAME, NAME_COLUMN_NAME, VERSION_COLUMN_NAME, STATE_COLUMN_NAME));
        for (ArtifactHolder artifact : artifactHolders) {
            lines.add(String.format(singleLineFormat, artifact.getId(), artifact.getSpringPowered() ? "S" : SPRING_POWERED_COLUMN_NAME, artifact.getName(), artifact.getVersion(), artifact.getState()));
        }
        return lines;
    }

    @Override
    public List<String> formatExamine(ManageableArtifact artifact) {
        ArrayList<String> lines = new ArrayList<String>();
        List<QuasiBundle> quasiBundles = this.quasiBundleUtil.getAllBundles();
        ArtifactHolder artifactHolder = this.getArtifactHolder(artifact, quasiBundles);
        if (artifactHolder == null) {
            lines.add("No artifact found of type '" + artifact.getType() + "' name '" + artifact.getName() + "' and version '" + artifact.getVersion() + "'");
        } else {
            lines.add(String.format("Id:              %s", artifactHolder.getId()));
            lines.add(String.format("Name:            %s", artifactHolder.getName()));
            lines.add(String.format("Version          %s", artifactHolder.getVersion()));
            lines.add(String.format("State:           %s", artifactHolder.getState()));
            lines.add(String.format("Spring Powered:  %s", artifactHolder.getSpringPowered()));
            String bundleLocation = artifactHolder.getBundleLocation();
            lines.add(String.format("Bundle Location: %s", bundleLocation == null ? "" : bundleLocation));
            lines.addAll(this.formatImportedPackages(artifactHolder));
            lines.addAll(this.formatExportedPackages(artifactHolder));
            lines.addAll(this.formatPublishedServices(artifactHolder));
            lines.addAll(this.formatConsumedServices(artifactHolder));
            lines.addAll(this.formatFragments(artifactHolder));
            lines.addAll(this.formatHost(artifactHolder));
        }
        return lines;
    }

    private List<String> formatConsumedServices(ArtifactHolder artifactHolder) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add(String.format("Consumed services:", new Object[0]));
        List<ServiceHolder> consumedServices = artifactHolder.getConsumedServices(this.quasiServiceUtil);
        if (consumedServices.isEmpty()) {
            lines.add(String.format("    None", new Object[0]));
        } else {
            for (ServiceHolder consumedService : consumedServices) {
                String objectClass = this.extractFirstObjectClass(consumedService.getProperties().get("objectClass"));
                lines.add(String.format("    %3s %s", consumedService.getServiceId(), objectClass));
                lines.add(String.format("        published by %s", this.formatBundleSummary(consumedService.getProvider())));
            }
        }
        return lines;
    }

    private List<String> formatPublishedServices(ArtifactHolder artifactHolder) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add(String.format("Published services:", new Object[0]));
        List<ServiceHolder> publishedServices = artifactHolder.getPublishedServices(this.quasiServiceUtil);
        if (publishedServices.isEmpty()) {
            lines.add(String.format("    None", new Object[0]));
        } else {
            for (ServiceHolder publishedService : publishedServices) {
                String objectClass = this.extractFirstObjectClass(publishedService.getProperties().get("objectClass"));
                lines.add(String.format("    %3s %s", publishedService.getServiceId(), objectClass));
                List<QuasiBundle> consumers = publishedService.getConsumers();
                for (QuasiBundle consumer : consumers) {
                    lines.add(String.format("        consumed by %s", this.formatBundleSummary(consumer)));
                }
            }
        }
        return lines;
    }

    private String extractFirstObjectClass(Object objectClass) {
        String[] objectClasses = objectClass instanceof String ? StringUtils.commaDelimitedListToStringArray((String)((String)objectClass)) : (objectClass instanceof Object[] ? (String[])objectClass : StringUtils.commaDelimitedListToStringArray((String)objectClass.toString()));
        if (objectClasses.length > 0) {
            return objectClasses[0];
        }
        return "<no object classes>";
    }

    private List<String> formatHost(ArtifactHolder artifactHolder) {
        ArrayList<String> lines = new ArrayList<String>();
        List<QuasiBundle> hosts = artifactHolder.getHosts();
        if (hosts != null && !hosts.isEmpty()) {
            lines.add("");
            lines.add(String.format("Host:", new Object[0]));
            QuasiBundle host = hosts.get(0);
            lines.add(String.format("    %s", this.formatBundleSummary(host)));
        }
        return lines;
    }

    private List<String> formatFragments(ArtifactHolder artifactHolder) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add(String.format("Fragments:", new Object[0]));
        List<QuasiBundle> fragments = artifactHolder.getFragments();
        if (fragments.isEmpty()) {
            lines.add(String.format("    None", new Object[0]));
        } else {
            for (QuasiBundle fragment : fragments) {
                lines.add(String.format("    %s", this.formatBundleSummary(fragment)));
            }
        }
        return lines;
    }

    private List<String> formatExportedPackages(ArtifactHolder artifactHolder) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add(String.format("Exported Packages:", new Object[0]));
        List<QuasiExportPackage> exportPackages = artifactHolder.getExportPackages();
        if (exportPackages.isEmpty()) {
            lines.add(String.format("    None", new Object[0]));
        } else {
            for (QuasiExportPackage exportPackage : exportPackages) {
                lines.add(String.format("    %s %s", exportPackage.getPackageName(), exportPackage.getVersion().toString()));
                for (QuasiImportPackage consumer : exportPackage.getConsumers()) {
                    QuasiBundle bundle = consumer.getImportingBundle();
                    lines.add(String.format("        imported by %s", this.formatBundleSummary(bundle)));
                }
            }
        }
        return lines;
    }

    private List<String> formatImportedPackages(ArtifactHolder artifactHolder) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        lines.add(String.format("Imported Packages:", new Object[0]));
        List<QuasiImportPackage> importPackages = artifactHolder.getImportPackages();
        if (importPackages.isEmpty()) {
            lines.add(String.format("    None", new Object[0]));
        } else {
            for (QuasiImportPackage importPackage : importPackages) {
                if (!importPackage.isResolved()) continue;
                lines.add(String.format("    %s %s", importPackage.getPackageName(), importPackage.getVersionConstraint().toString()));
                QuasiBundle bundle = importPackage.getProvider().getExportingBundle();
                lines.add(String.format("        exported by %s", this.formatBundleSummary(bundle)));
            }
        }
        return lines;
    }

    private String formatBundleSummary(QuasiBundle bundle) {
        return String.format("%s %s [%s]", bundle.getSymbolicName(), bundle.getVersion(), bundle.getBundleId());
    }

    public List<String> formatDiag(QuasiBundle bundle, List<QuasiResolutionFailure> resolverReport) {
        if (bundle == null) {
            return Arrays.asList("Unable to locate bundle");
        }
        if (resolverReport.size() == 0) {
            return Arrays.asList("No resolution errors found");
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (QuasiResolutionFailure quasiResolutionFailure : resolverReport) {
            lines.add(String.format("%s", quasiResolutionFailure.getDescription()));
        }
        return lines;
    }

    public List<String> formatHeaders(QuasiBundle quasiBundle) {
        if (quasiBundle == null) {
            return Arrays.asList("Unable to locate bundle");
        }
        ArrayList<String> lines = new ArrayList<String>();
        Bundle bundle = quasiBundle.getBundle();
        if (bundle != null) {
            Dictionary headers = bundle.getHeaders();
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                lines.add(String.format("%s: ", key));
                lines.addAll(this.formatHeaderValue((String)headers.get(key)));
            }
        }
        return lines;
    }

    private List<ArtifactHolder> getArtifactHolders(List<ManageableArtifact> artifacts) {
        ArrayList<ArtifactHolder> artifactHolders = new ArrayList<ArtifactHolder>(artifacts.size());
        List<QuasiBundle> bundles = this.quasiBundleUtil.getAllBundles();
        for (ManageableArtifact artifact : artifacts) {
            ArtifactHolder artifactHolder = this.getArtifactHolder(artifact, bundles);
            if (artifactHolder == null) continue;
            artifactHolders.add(artifactHolder);
        }
        return artifactHolders;
    }

    private ArtifactHolder getArtifactHolder(ManageableArtifact artifact, List<QuasiBundle> bundles) {
        Version v = new Version(artifact.getVersion());
        Set bundleIds = this.userRegion.getBundleIds();
        for (QuasiBundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(artifact.getName()) || !bundle.getVersion().equals((Object)v) || !bundleIds.contains(bundle.getBundleId())) continue;
            return new ArtifactHolder(artifact, bundle, this.moduleContextAccessor);
        }
        return null;
    }

    private List<String> formatHeaderValue(String value) {
        ArrayList<String> lines = new ArrayList<String>();
        StringReader reader = new StringReader(value);
        char[] buffer = new char[71];
        int length = 0;
        try {
            while ((length = reader.read(buffer)) != -1) {
                lines.add(String.format(" %s", new String(buffer, 0, length)));
            }
        }
        catch (IOException iOException) {}
        return lines;
    }

    private static class ArtifactHolder
    implements Comparable<ArtifactHolder> {
        private final ModuleContextAccessor moduleContextAccessor;
        private final ManageableArtifact artifact;
        private final QuasiBundle bundle;

        public ArtifactHolder(ManageableArtifact artifact, QuasiBundle bundle, ModuleContextAccessor moduleContextAccessor) {
            this.artifact = artifact;
            this.bundle = bundle;
            this.moduleContextAccessor = moduleContextAccessor;
        }

        public Long getId() {
            return this.bundle.getBundleId();
        }

        public String getName() {
            return this.artifact.getName();
        }

        public String getState() {
            return this.artifact.getState();
        }

        public String getVersion() {
            return this.artifact.getVersion();
        }

        public String getBundleLocation() {
            return this.bundle.getBundleLocation();
        }

        public boolean getSpringPowered() {
            ModuleContext moduleContext;
            Bundle realBundle = this.bundle.getBundle();
            return realBundle != null && (moduleContext = this.moduleContextAccessor.getModuleContext(realBundle)) != null;
        }

        public List<QuasiExportPackage> getExportPackages() {
            return this.bundle.getExportPackages();
        }

        public List<QuasiImportPackage> getImportPackages() {
            return this.bundle.getImportPackages();
        }

        public List<QuasiBundle> getFragments() {
            return this.bundle.getFragments();
        }

        public List<QuasiBundle> getHosts() {
            return this.bundle.getHosts();
        }

        public List<ServiceHolder> getPublishedServices(QuasiServiceUtil quasiServiceUtil) {
            ArrayList<ServiceHolder> services = new ArrayList<ServiceHolder>();
            List<ServiceHolder> allServices = quasiServiceUtil.getAllServices();
            for (ServiceHolder quasiLiveService : allServices) {
                if (!quasiLiveService.getProvider().equals(this.bundle)) continue;
                services.add(quasiLiveService);
            }
            return services;
        }

        public List<ServiceHolder> getConsumedServices(QuasiServiceUtil quasiServiceUtil) {
            ArrayList<ServiceHolder> services = new ArrayList<ServiceHolder>();
            List<ServiceHolder> allServices = quasiServiceUtil.getAllServices();
            for (ServiceHolder quasiLiveService : allServices) {
                List<QuasiBundle> consumers = quasiLiveService.getConsumers();
                for (QuasiBundle quasiBundle : consumers) {
                    if (!quasiBundle.equals(this.bundle) || services.contains(quasiLiveService)) continue;
                    services.add(quasiLiveService);
                }
            }
            return services;
        }

        @Override
        public int compareTo(ArtifactHolder o) {
            return this.getId().compareTo(o.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ArtifactHolder && this.getId().equals(((ArtifactHolder)obj).getId());
        }
    }
}

