/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.CommandDescriptor;
import org.eclipse.virgo.shell.internal.CommandRegistry;
import org.eclipse.virgo.shell.internal.help.HelpAccessor;

@Command(value="help")
final class HelpCommand {
    private final CommandRegistry commandRegistry;
    private final HelpAccessor helpAccessor;

    HelpCommand(CommandRegistry commandRegistry, HelpAccessor helpAccessor) {
        this.commandRegistry = commandRegistry;
        this.helpAccessor = helpAccessor;
    }

    @Command(value="")
    public List<String> summaryHelp() {
        ArrayList<String> lines = new ArrayList<String>();
        SortedMap<String, CommandDescriptor> topLevelCommands = this.getTopLevelCommands();
        Set<String> sortedCommandNames = topLevelCommands.keySet();
        int width = this.maxWidthOfCommandNames(sortedCommandNames);
        String lineFormatNull = String.format("    %%-%ds", width);
        String lineFormat = String.format("    %%-%ds - %%s", width);
        lines.add("");
        for (String commandName : sortedCommandNames) {
            String commandHelp = this.helpAccessor.getSummaryHelp(((CommandDescriptor)topLevelCommands.get(commandName)).getTarget().getClass());
            if (commandHelp == null) {
                lines.add(String.format(lineFormatNull, commandName));
                continue;
            }
            lines.add(String.format(lineFormat, commandName, commandHelp));
        }
        lines.add("");
        return lines;
    }

    private int maxWidthOfCommandNames(Set<String> keySet) {
        int result = 0;
        for (String key : keySet) {
            if (result >= key.length()) continue;
            result = key.length();
        }
        return result < 8 ? 8 : result;
    }

    @Command(value="")
    public List<String> detailedHelp(String command) {
        SortedMap<String, CommandDescriptor> commandMap = this.getTopLevelCommands();
        CommandDescriptor descriptor = (CommandDescriptor)commandMap.get(command);
        if (descriptor == null) {
            return Arrays.asList(String.format("No help is available as command '%s' is unknown", command));
        }
        List<String> detailedHelp = this.helpAccessor.getDetailedHelp(descriptor.getTarget().getClass());
        if (detailedHelp == null || detailedHelp.size() == 0) {
            return Arrays.asList(String.format("No help is available for command '%s'", command));
        }
        return detailedHelp;
    }

    private SortedMap<String, CommandDescriptor> getTopLevelCommands() {
        TreeMap<String, CommandDescriptor> commandMap = new TreeMap<String, CommandDescriptor>();
        List<CommandDescriptor> commands = this.commandRegistry.getCommandDescriptors();
        for (CommandDescriptor command : commands) {
            commandMap.put(command.getCommandName(), command);
        }
        return commandMap;
    }
}

