/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.commands;

import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.shell.Command;
import org.eclipse.virgo.shell.internal.commands.AbstractInstallArtifactBasedCommands;
import org.eclipse.virgo.shell.internal.formatting.BundleInstallArtifactCommandFormatter;
import org.eclipse.virgo.shell.internal.util.QuasiBundleUtil;
import org.eclipse.virgo.shell.internal.util.QuasiServiceUtil;
import org.osgi.framework.Version;

@Command(value="bundle")
final class BundleCommands
extends AbstractInstallArtifactBasedCommands<ManageableArtifact> {
    private static final String NO_BUNDLE_FOR_BUNDLE_ID = "No bundle with id '%s' was found";
    private static final String TYPE = "bundle";
    private final BundleInstallArtifactCommandFormatter formatter;
    private final QuasiBundleUtil quasiBundleUtil;

    public BundleCommands(RuntimeArtifactModelObjectNameCreator objectNameCreator, QuasiBundleUtil quasiBundleUtil, QuasiServiceUtil quasiServiceUtil, ModuleContextAccessor moduleContextAccessor, RegionDigraph regionDigraph) {
        super(TYPE, objectNameCreator, new BundleInstallArtifactCommandFormatter(regionDigraph, quasiBundleUtil, quasiServiceUtil, moduleContextAccessor), ManageableArtifact.class, regionDigraph);
        this.quasiBundleUtil = quasiBundleUtil;
        this.formatter = new BundleInstallArtifactCommandFormatter(regionDigraph, quasiBundleUtil, quasiServiceUtil, moduleContextAccessor);
    }

    @Command(value="examine")
    public List<String> examine(long id) {
        QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
        if (bundle != null) {
            return this.examine(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName());
        }
        return Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
    }

    @Command(value="start")
    public List<String> start(long id) {
        QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
        if (bundle != null) {
            return this.start(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName());
        }
        return Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
    }

    @Command(value="stop")
    public List<String> stop(long id) {
        QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
        if (bundle != null) {
            return this.stop(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName());
        }
        return Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
    }

    @Command(value="refresh")
    public List<String> refresh(long id) {
        QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
        if (bundle != null) {
            return this.refresh(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName());
        }
        return Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
    }

    @Command(value="uninstall")
    public List<String> uninstall(long id) {
        QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
        if (bundle != null) {
            return this.uninstall(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName());
        }
        return Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
    }

    @Command(value="diag")
    public List<String> diag(long id) {
        QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
        if (bundle != null) {
            return this.diag(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName());
        }
        return Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
    }

    @Command(value="diag")
    public List<String> diag(String name, String version, String region) {
        QuasiBundle bundle = this.getBundle(name, version, region);
        if (bundle != null) {
            List<QuasiResolutionFailure> resolverReport = this.quasiBundleUtil.getResolverReport(bundle.getBundleId());
            return this.formatter.formatDiag(bundle, resolverReport);
        }
        return this.getDoesNotExistMessage(TYPE, name, version, region);
    }

    @Command(value="headers")
    public List<String> headers(long id) {
        QuasiBundle bundle = this.quasiBundleUtil.getBundle(id);
        if (bundle != null) {
            return this.headers(bundle.getSymbolicName(), bundle.getVersion().toString(), bundle.getRegion().getName());
        }
        return Arrays.asList(String.format(NO_BUNDLE_FOR_BUNDLE_ID, id));
    }

    @Command(value="headers")
    public List<String> headers(String name, String version, String region) {
        return this.formatter.formatHeaders(this.getBundle(name, version, region));
    }

    private QuasiBundle getBundle(String name, String version, String region) {
        Version v = new Version(version);
        List<QuasiBundle> bundles = this.quasiBundleUtil.getAllBundles();
        for (QuasiBundle bundle : bundles) {
            if (!bundle.getSymbolicName().equals(name) || !bundle.getVersion().equals((Object)v) || !bundle.getRegion().equals(region)) continue;
            return bundle;
        }
        return null;
    }
}

