/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.gemini.web.core.WebContainer;
import org.eclipse.gemini.web.core.spi.ServletContainer;
import org.eclipse.gemini.web.core.spi.ServletContainerException;
import org.eclipse.gemini.web.core.spi.WebApplicationHandle;
import org.eclipse.gemini.web.internal.EventManager;
import org.eclipse.gemini.web.internal.StandardWebApplication;
import org.eclipse.gemini.web.internal.WebApplicationStartFailureRetryController;
import org.eclipse.gemini.web.internal.WebContainerUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardWebContainer
implements WebContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardWebContainer.class);
    private final EventManager eventManager;
    private final ServletContainer servletContainer;
    private final WebApplicationStartFailureRetryController retryController = new WebApplicationStartFailureRetryController();
    private final BundleContext bundleContext;

    public StandardWebContainer(ServletContainer servletContainer, EventManager eventManager, BundleContext bundleContext) {
        this.servletContainer = servletContainer;
        this.eventManager = eventManager;
        this.bundleContext = bundleContext;
    }

    @Override
    public WebApplication createWebApplication(Bundle bundle) throws BundleException {
        return this.createWebApplication(bundle, null);
    }

    @Override
    public WebApplication createWebApplication(Bundle bundle, Bundle extender) throws BundleException {
        if (!this.isWebBundle(bundle)) {
            throw new BundleException("Bundle '" + bundle + "' is not a valid web bundle.");
        }
        try {
            WebApplicationHandle handle = this.servletContainer.createWebApplication(WebContainerUtils.getContextPath(bundle), bundle);
            handle.getServletContext().setAttribute("osgi-bundlecontext", (Object)bundle.getBundleContext());
            return new StandardWebApplication(bundle, extender, handle, this.servletContainer, this.eventManager, this.retryController, this.bundleContext);
        }
        catch (ServletContainerException ex) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to create web application for bundle '" + bundle + "'", (Throwable)ex);
            }
            throw new BundleException("Failed to create web application for bundle '" + bundle + "'", (Throwable)ex);
        }
    }

    @Override
    public boolean isWebBundle(Bundle bundle) {
        return WebContainerUtils.isWebBundle(bundle);
    }

    @Override
    public void halt() {
        this.retryController.clear();
    }
}

