/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;

public class ComponentFactoryImpl
implements ComponentFactory {
    private ServiceComponentProp sci;

    public ComponentFactoryImpl(ServiceComponentProp component) {
        this.sci = component;
    }

    public ComponentInstance newInstance(Dictionary additionalProps) {
        ComponentInstanceImpl instance = null;
        ServiceComponentProp newSCP = null;
        try {
            if (Activator.DEBUG) {
                Activator.log.debug("ComponentFactoryImpl.newInstance(): " + this.sci.name, null);
            }
            Hashtable props = new Hashtable((Map)((Object)this.sci.getProperties()));
            SCRUtil.copyTo(props, additionalProps);
            newSCP = InstanceProcess.resolver.mapNewFactoryComponent(this.sci.serviceComponent, props);
            Vector<ServiceComponentProp> toBuild = new Vector<ServiceComponentProp>(1);
            toBuild.addElement(newSCP);
            InstanceProcess.staticRef.buildComponents(toBuild, Activator.security);
            if (!newSCP.instances.isEmpty()) {
                instance = (ComponentInstanceImpl)newSCP.instances.firstElement();
            }
            if (instance == null && !newSCP.isImmediate()) {
                instance = InstanceProcess.staticRef.buildComponent(null, newSCP, null, Activator.security);
            }
            if (instance == null) {
                throw new ComponentException(Messages.COULD_NOT_CREATE_NEW_INSTANCE);
            }
        }
        catch (Throwable e) {
            if (newSCP != null) {
                this.disposeSCP(newSCP);
            }
            if (e instanceof ComponentException) {
                throw (ComponentException)e;
            }
            Activator.log(null, 1, "ComponentFactoryImpl.newInstance(): failed for " + this.sci.name + " with properties " + additionalProps, e);
            throw new ComponentException(Messages.COULD_NOT_CREATE_NEW_INSTANCE, e);
        }
        return instance;
    }

    private void disposeSCP(ServiceComponentProp scp) {
        scp.serviceComponent.componentProps.removeElement(scp);
        Vector<ServiceComponentProp> toDispose = new Vector<ServiceComponentProp>(1);
        toDispose.addElement(scp);
        InstanceProcess.resolver.disposeComponentConfigs(toDispose, 0);
        scp.setState(256);
    }

    public String toString() {
        return "ComponentFactory for " + this.sci.name;
    }
}

