/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.module.internal;

import org.eclipse.virgo.kernel.module.Component;
import org.eclipse.virgo.kernel.module.ModuleContext;
import org.eclipse.virgo.kernel.module.NoSuchComponentException;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;

final class ModuleContextWrapper
implements ModuleContext {
    private final ConfigurableApplicationContext appCtx;

    ModuleContextWrapper(ConfigurableApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    @Override
    public Object getApplicationContext() {
        return this.appCtx;
    }

    @Override
    public Component getComponent(final String componentName) throws NoSuchComponentException {
        try {
            final Object component = this.appCtx.getBean(componentName);
            return new Component(){

                @Override
                public String getName() {
                    return componentName;
                }

                @Override
                public String getType() {
                    return component.getClass().getName();
                }

                @Override
                public boolean isPrototype() {
                    return ModuleContextWrapper.this.appCtx.getBeanFactory().isPrototype(componentName);
                }

                @Override
                public boolean isSingleton() {
                    return ModuleContextWrapper.this.appCtx.getBeanFactory().isSingleton(componentName);
                }
            };
        }
        catch (BeansException e) {
            throw new NoSuchComponentException(e.getMessage());
        }
    }

    @Override
    public String[] getComponentNames() {
        return this.appCtx.getBeanDefinitionNames();
    }

    @Override
    public String getDisplayName() {
        return this.appCtx.getDisplayName();
    }
}

