/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.app.spring;

import java.util.Collection;
import org.eclipse.gemini.blueprint.context.ConfigurableOsgiBundleApplicationContext;
import org.eclipse.virgo.kernel.deployer.app.spring.ModuleContextWrapper;
import org.eclipse.virgo.kernel.module.KernelModuleContextAccessorFactory;
import org.eclipse.virgo.kernel.module.ModuleContext;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.nano.serviceability.Assert;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

final class UserRegionModuleContextAccessor
implements ModuleContextAccessor {
    private final ModuleContextAccessor kernelModuleContextAccessor = KernelModuleContextAccessorFactory.create();

    UserRegionModuleContextAccessor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleContext getModuleContext(@NonNull Bundle bundle) {
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) return this.kernelModuleContextAccessor.getModuleContext(bundle);
        String symbolicName = bundle.getSymbolicName();
        try {
            Collection refs = bundleContext.getServiceReferences(ApplicationContext.class, "(Bundle-SymbolicName=" + symbolicName + ")");
            if (refs.size() == 0) return this.kernelModuleContextAccessor.getModuleContext(bundle);
            for (ServiceReference ref : refs) {
                Object service = bundleContext.getService(ref);
                try {
                    ApplicationContext appCtx;
                    if (!(service instanceof ApplicationContext) || !((appCtx = (ApplicationContext)service) instanceof ConfigurableOsgiBundleApplicationContext) || bundleContext != ((ConfigurableOsgiBundleApplicationContext)appCtx).getBundleContext()) continue;
                    ModuleContextWrapper moduleContextWrapper = new ModuleContextWrapper((ConfigurableApplicationContext)((ConfigurableOsgiBundleApplicationContext)appCtx));
                    return moduleContextWrapper;
                }
                finally {
                    bundleContext.ungetService(ref);
                }
            }
            return this.kernelModuleContextAccessor.getModuleContext(bundle);
        }
        catch (InvalidSyntaxException e) {
            Assert.isFalse((boolean)true, (String)"Unexpected exception %s", (Object[])new Object[]{e.getMessage()});
        }
        return this.kernelModuleContextAccessor.getModuleContext(bundle);
    }
}

