/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.CompositeData;
import org.eclipse.gemini.management.framework.internal.BundleBatchActionResult;
import org.eclipse.gemini.management.framework.internal.BundleBatchInstallResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.jmx.framework.FrameworkMBean;

public final class Framework
implements FrameworkMBean {
    private BundleContext bundleContext;
    private FrameworkStartLevel frameworkStartLevel;
    private FrameworkWiring frameworkWiring;

    public Framework(BundleContext bc) {
        this.bundleContext = bc;
        this.frameworkStartLevel = (FrameworkStartLevel)bc.getBundle(0L).adapt(FrameworkStartLevel.class);
        this.frameworkWiring = (FrameworkWiring)bc.getBundle(0L).adapt(FrameworkWiring.class);
    }

    public int getFrameworkStartLevel() throws IOException {
        return this.frameworkStartLevel.getStartLevel();
    }

    public int getInitialBundleStartLevel() throws IOException {
        return this.frameworkStartLevel.getInitialBundleStartLevel();
    }

    public long installBundle(String location) throws IOException {
        try {
            return this.bundleContext.installBundle(location).getBundleId();
        }
        catch (Throwable e) {
            throw new IOException("Unable to install bundle: " + e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long installBundleFromURL(String location, String url) throws IOException {
        long l;
        InputStream is = null;
        try {
            is = new URL(url).openStream();
            l = this.bundleContext.installBundle(location, is).getBundleId();
            if (is == null) return l;
        }
        catch (Throwable e) {
            try {
                throw new IOException("Unable to install bundle: " + e);
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            is.close();
            return l;
        }
        catch (IOException iOException) {}
        return l;
    }

    public CompositeData installBundles(String[] locations) throws IOException {
        if (locations == null) {
            throw new IOException("locations must not be null");
        }
        Long[] ids = new Long[locations.length];
        int i = 0;
        while (i < locations.length) {
            try {
                ids[i] = this.bundleContext.installBundle(locations[i]).getBundleId();
            }
            catch (Throwable e) {
                Long[] completed = new Long[i];
                System.arraycopy(ids, 0, completed, 0, completed.length);
                String[] remaining = new String[locations.length - i - 1];
                System.arraycopy(locations, i + 1, remaining, 0, remaining.length);
                return new BundleBatchInstallResult(e.toString(), completed, locations[i], remaining).asCompositeData();
            }
            ++i;
        }
        return new BundleBatchInstallResult(ids).asCompositeData();
    }

    public CompositeData installBundlesFromURL(String[] locations, String[] urls) throws IOException {
        if (locations == null) {
            throw new IOException("locations must not be null");
        }
        if (urls == null) {
            throw new IOException("urls must not be null");
        }
        Long[] ids = new Long[locations.length];
        int i = 0;
        while (i < locations.length) {
            InputStream is = null;
            try {
                try {
                    is = new URL(urls[i]).openStream();
                    ids[i] = this.bundleContext.installBundle(locations[i], is).getBundleId();
                }
                catch (Throwable e) {
                    Long[] completed = new Long[i];
                    System.arraycopy(ids, 0, completed, 0, completed.length);
                    String[] remaining = new String[locations.length - i - 1];
                    System.arraycopy(locations, i + 1, remaining, 0, remaining.length);
                    CompositeData compositeData = new BundleBatchInstallResult(e.toString(), completed, locations[i], remaining).asCompositeData();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return compositeData;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return new BundleBatchInstallResult(ids).asCompositeData();
    }

    public void refreshBundle(long bundleIdentifier) throws IOException {
        List<Bundle> bundles = Arrays.asList(this.bundle(bundleIdentifier));
        this.frameworkWiring.refreshBundles(bundles, new FrameworkListener[0]);
    }

    public void refreshBundles(long[] bundleIdentifiers) throws IOException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (bundleIdentifiers != null) {
            int i = 0;
            while (i < bundleIdentifiers.length) {
                try {
                    bundles.add(this.bundle(bundleIdentifiers[i]));
                }
                catch (Throwable e) {
                    IOException iox = new IOException("Unable to refresh packages");
                    iox.initCause(e);
                    throw iox;
                }
                ++i;
            }
        }
        try {
            this.frameworkWiring.refreshBundles(bundles, new FrameworkListener[0]);
        }
        catch (Throwable e) {
            IOException iox = new IOException("Unable to refresh packages");
            iox.initCause(e);
            throw iox;
        }
    }

    public boolean resolveBundle(long bundleIdentifier) throws IOException {
        List<Bundle> bundles = Arrays.asList(this.bundle(bundleIdentifier));
        return this.frameworkWiring.resolveBundles(bundles);
    }

    public boolean resolveBundles(long[] bundleIdentifiers) throws IOException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (bundleIdentifiers != null) {
            int i = 0;
            while (i < bundleIdentifiers.length) {
                bundles.add(this.bundle(bundleIdentifiers[i]));
                ++i;
            }
        }
        return this.frameworkWiring.resolveBundles(bundles);
    }

    public void restartFramework() throws IOException {
        try {
            this.bundle(0L).update();
        }
        catch (BundleException e) {
            throw new IOException("Unable to restart framework: " + (Object)((Object)e));
        }
    }

    public void setBundleStartLevel(long bundleIdentifier, int newlevel) throws IOException {
        try {
            ((BundleStartLevel)this.bundle(bundleIdentifier).adapt(BundleStartLevel.class)).setStartLevel(newlevel);
        }
        catch (Throwable e) {
            IOException iox = new IOException("Cannot set start level: " + e);
            iox.initCause(e);
            throw iox;
        }
    }

    public CompositeData setBundleStartLevels(long[] bundleIdentifiers, int[] newlevels) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        if (newlevels == null) {
            throw new IOException("new start levels must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                ((BundleStartLevel)this.bundle(bundleIdentifiers[i]).adapt(BundleStartLevel.class)).setStartLevel(newlevels[i]);
            }
            catch (Throwable e) {
                Long[] completed = new Long[i];
                System.arraycopy(bundleIdentifiers, 0, completed, 0, completed.length);
                Long[] remaining = new Long[bundleIdentifiers.length - i - 1];
                System.arraycopy(bundleIdentifiers, i + 1, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void setFrameworkStartLevel(int newlevel) throws IOException {
        try {
            this.frameworkStartLevel.setStartLevel(newlevel, new FrameworkListener[0]);
        }
        catch (Throwable e) {
            IOException iox = new IOException("Cannot set start level: " + e);
            iox.initCause(e);
            throw iox;
        }
    }

    public void setInitialBundleStartLevel(int newlevel) throws IOException {
        try {
            this.frameworkStartLevel.setInitialBundleStartLevel(newlevel);
        }
        catch (Throwable e) {
            IOException iox = new IOException("Cannot set start level: " + e);
            iox.initCause(e);
            throw iox;
        }
    }

    public void shutdownFramework() throws IOException {
        try {
            this.bundle(0L).stop();
        }
        catch (Throwable be) {
            throw new IOException("Shutting down not implemented in this framework: " + be);
        }
    }

    public void startBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).start();
        }
        catch (Throwable e) {
            throw new IOException("Unable to start bundle: " + e);
        }
    }

    public CompositeData startBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                this.bundle(bundleIdentifiers[i]).start();
            }
            catch (Throwable e) {
                Long[] completed = new Long[i];
                System.arraycopy(bundleIdentifiers, 0, completed, 0, completed.length);
                Long[] remaining = new Long[bundleIdentifiers.length - i - 1];
                System.arraycopy(bundleIdentifiers, i + 1, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void stopBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).stop();
        }
        catch (Throwable e) {
            throw new IOException("Unable to stop bundle: " + e);
        }
    }

    public CompositeData stopBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                this.bundle(bundleIdentifiers[i]).stop();
            }
            catch (Throwable e) {
                Long[] completed = new Long[i];
                System.arraycopy(bundleIdentifiers, 0, completed, 0, completed.length);
                Long[] remaining = new Long[bundleIdentifiers.length - i - 1];
                System.arraycopy(bundleIdentifiers, i + 1, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void uninstallBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).uninstall();
        }
        catch (BundleException e) {
            throw new IOException("Unable to uninstall bundle: " + (Object)((Object)e));
        }
    }

    public CompositeData uninstallBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                this.bundle(bundleIdentifiers[i]).uninstall();
            }
            catch (Throwable e) {
                Long[] completed = new Long[i];
                System.arraycopy(bundleIdentifiers, 0, completed, 0, completed.length);
                Long[] remaining = new Long[bundleIdentifiers.length - i - 1];
                System.arraycopy(bundleIdentifiers, i + 1, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void updateBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).update();
        }
        catch (Throwable e) {
            throw new IOException("Unable to update bundle: " + e);
        }
    }

    public void updateBundleFromURL(long bundleIdentifier, String url) throws IOException {
        InputStream is = null;
        try {
            try {
                is = new URL(url).openStream();
                this.bundle(bundleIdentifier).update(is);
            }
            catch (Throwable e) {
                throw new IOException("Unable to update bundle: " + e);
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public CompositeData updateBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                this.bundle(bundleIdentifiers[i]).update();
            }
            catch (Throwable e) {
                Long[] completed = new Long[i];
                System.arraycopy(bundleIdentifiers, 0, completed, 0, completed.length);
                Long[] remaining = new Long[bundleIdentifiers.length - i - 1];
                System.arraycopy(bundleIdentifiers, i + 1, remaining, 0, remaining.length);
                return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public CompositeData updateBundlesFromURL(long[] bundleIdentifiers, String[] urls) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            InputStream is = null;
            try {
                try {
                    is = new URL(urls[i]).openStream();
                    this.bundle(bundleIdentifiers[i]).update(is);
                }
                catch (Throwable e) {
                    Long[] completed = new Long[i];
                    System.arraycopy(bundleIdentifiers, 0, completed, 0, completed.length);
                    Long[] remaining = new Long[bundleIdentifiers.length - i - 1];
                    System.arraycopy(bundleIdentifiers, i + 1, remaining, 0, remaining.length);
                    CompositeData compositeData = new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[i], remaining).asCompositeData();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return compositeData;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    public void updateFramework() throws IOException {
        try {
            this.bundle(0L).update();
        }
        catch (BundleException be) {
            throw new IOException("Update of the framework is not implemented: " + (Object)((Object)be));
        }
    }

    private Bundle bundle(long bundleIdentifier) throws IOException {
        Bundle b = this.bundleContext.getBundle(bundleIdentifier);
        if (b == null) {
            throw new IOException("Bundle <" + bundleIdentifier + "> does not exist");
        }
        return b;
    }
}

