/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.equinox.extensions.hooks;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class MetaInfResourceClassLoaderDelegateHook
implements ClassLoaderDelegateHook {
    private static final String SPRINGDM_DELEGATED_NAMESPACE_HANDLER_RESOLVER_CLASS_NAME = "org.springframework.osgi.context.support.DelegatedNamespaceHandlerResolver";
    private static final String SPRINGDM_DELEGATED_ENTITY_RESOLVER_CLASS_NAME = "org.springframework.osgi.context.support.DelegatedEntityResolver";
    private static final String BLUEPRINT_DELEGATED_NAMESPACE_HANDLER_RESOLVER_CLASS_NAME = "org.eclipse.gemini.blueprint.context.support.DelegatedNamespaceHandlerResolver";
    private static final String BLUEPRINT_DELEGATED_ENTITY_RESOLVER_CLASS_NAME = "org.eclipse.gemini.blueprint.context.support.ChainedEntityResolver";
    private static final String EXCLUDED_RESOURCE_MANIFEST = "MANIFEST.MF";
    private static final String EXCLUDED_RESOURCE_SPRING_DIR = "spring";
    private static final String EXCLUDED_RESOURCE_BLUEPRINT_DIR = "blueprint";
    private static final String EXCLUDED_RESOURCE_SPRING_DIR_SUFFIX = ".xml";
    private final BundleContext systemBundleContext;
    private final PackageAdmin packageAdmin;
    private final ThreadLocal<Object> resourceSearchInProgress = new ThreadLocal();
    private final Object SEARCH_IN_PROGRESS_MARKER = new Object();
    private final Object monitor = new Object();
    private final WeakHashMap<Bundle, Set<Bundle>> dependenciesCache = new WeakHashMap();
    private final BundleListener cacheClearingBundleListener = new CacheClearingBundleListener();

    public MetaInfResourceClassLoaderDelegateHook(BundleContext systemBundleContext, PackageAdmin packageAdmin) {
        this.systemBundleContext = systemBundleContext;
        this.packageAdmin = packageAdmin;
    }

    public void init() {
        this.systemBundleContext.addBundleListener(this.cacheClearingBundleListener);
    }

    public void destroy() {
        this.systemBundleContext.removeBundleListener(this.cacheClearingBundleListener);
    }

    public URL postFindResource(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        if (this.resourceSearchInProgress.get() == null && this.isDelegatedResource(name)) {
            try {
                Bundle[] bundles;
                this.resourceSearchInProgress.set(this.SEARCH_IN_PROGRESS_MARKER);
                Bundle[] bundleArray = bundles = this.getDependencyBundles(classLoader.getBundle());
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle dependency;
                    block10: {
                        dependency = bundleArray[n2];
                        int state = dependency.getState();
                        if (state != 32 && state != 4) break block10;
                        URL resource = dependency.getResource(name);
                        if (resource != null) {
                            URL uRL = resource;
                            return uRL;
                        }
                    }
                    try {
                        this.removeDependency(classLoader.getBundle(), dependency);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.removeDependency(classLoader.getBundle(), dependency);
                    }
                    ++n2;
                }
            }
            finally {
                this.resourceSearchInProgress.set(null);
            }
        }
        return null;
    }

    public Enumeration<URL> postFindResources(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        if (this.resourceSearchInProgress.get() == null && this.isDelegatedResource(name)) {
            try {
                Bundle[] bundles;
                this.resourceSearchInProgress.set(this.SEARCH_IN_PROGRESS_MARKER);
                HashSet<URL> found = new HashSet<URL>();
                Bundle[] bundleArray = bundles = this.getDependencyBundles(classLoader.getBundle());
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle dependency = bundleArray[n2];
                    try {
                        int state = dependency.getState();
                        if (state == 4 || state == 32) {
                            this.addAll(found, dependency.getResources(name));
                        } else {
                            this.removeDependency(classLoader.getBundle(), dependency);
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.removeDependency(classLoader.getBundle(), dependency);
                    }
                    ++n2;
                }
                if (!found.isEmpty()) {
                    IteratorEnumerationAdaptor<URL> iteratorEnumerationAdaptor = new IteratorEnumerationAdaptor<URL>(found.iterator());
                    return iteratorEnumerationAdaptor;
                }
            }
            finally {
                this.resourceSearchInProgress.set(null);
            }
        }
        return null;
    }

    private boolean isDelegatedResource(String name) {
        return this.isMetaInfResource(name) && !this.isDelegatedResolverCall();
    }

    private boolean isMetaInfResource(String name) {
        if (!name.startsWith("/META-INF") && !name.startsWith("META-INF")) {
            return false;
        }
        if (name.contains(EXCLUDED_RESOURCE_MANIFEST)) {
            return false;
        }
        return !name.contains(EXCLUDED_RESOURCE_SPRING_DIR) && !name.contains(EXCLUDED_RESOURCE_BLUEPRINT_DIR) || !name.endsWith(EXCLUDED_RESOURCE_SPRING_DIR_SUFFIX);
    }

    private boolean isDelegatedResolverCall() {
        Class<?>[] stackTrace = new SecurityManagerExecutionStackAccessor().getExecutionStack();
        return this.isSpringDmDelegatedResolverCall(stackTrace) || this.isBlueprintDelegatedResolverCall(stackTrace);
    }

    private boolean isSpringDmDelegatedResolverCall(Class<?>[] stackTrace) {
        return this.isDelegatedResolverCall(stackTrace, SPRINGDM_DELEGATED_NAMESPACE_HANDLER_RESOLVER_CLASS_NAME, SPRINGDM_DELEGATED_ENTITY_RESOLVER_CLASS_NAME);
    }

    private boolean isBlueprintDelegatedResolverCall(Class<?>[] stackTrace) {
        return this.isDelegatedResolverCall(stackTrace, BLUEPRINT_DELEGATED_NAMESPACE_HANDLER_RESOLVER_CLASS_NAME, BLUEPRINT_DELEGATED_ENTITY_RESOLVER_CLASS_NAME);
    }

    private boolean isDelegatedResolverCall(Class<?>[] stackTrace, String namespaceResolver, String entityResolver) {
        Class<?>[] classArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            String className = clazz.getName();
            if (namespaceResolver.equals(className) || entityResolver.equals(className)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addAll(Collection<URL> target, Enumeration<URL> source) {
        while (source != null && source.hasMoreElements()) {
            target.add(source.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle[] getDependencyBundles(Bundle bundle) {
        Object object = this.monitor;
        synchronized (object) {
            Set<Bundle> dependencies = this.dependenciesCache.get(bundle);
            if (dependencies != null) {
                return dependencies.toArray(new Bundle[dependencies.size()]);
            }
        }
        Set<Bundle> dependencies = this.determineDependencies(bundle);
        Object object2 = this.monitor;
        synchronized (object2) {
            this.dependenciesCache.put(bundle, dependencies);
            return dependencies.toArray(new Bundle[dependencies.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDependency(Bundle bundle, Bundle dependency) {
        Object object = this.monitor;
        synchronized (object) {
            Set<Bundle> dependencies = this.dependenciesCache.get(bundle);
            if (dependencies != null) {
                dependencies.remove(dependency);
            }
        }
    }

    private Set<Bundle> determineDependencies(Bundle bundle) {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        Bundle[] bundleArray = this.systemBundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportedPackage[] exportedPackages;
            Bundle candidate = bundleArray[n2];
            if (!candidate.equals(bundle) && (exportedPackages = this.getExportedPackages(candidate)) != null) {
                ExportedPackage[] exportedPackageArray = exportedPackages;
                int n3 = exportedPackages.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportedPackage exportedPackage = exportedPackageArray[n4];
                    Bundle[] importingBundles = exportedPackage.getImportingBundles();
                    if (importingBundles != null) {
                        Bundle[] bundleArray2 = importingBundles;
                        int n5 = importingBundles.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Bundle importer = bundleArray2[n6];
                            if (importer.equals(bundle)) {
                                bundles.add(candidate);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return bundles;
    }

    protected ExportedPackage[] getExportedPackages(Bundle bundle) {
        return this.packageAdmin.getExportedPackages(bundle);
    }

    public Class<?> postFindClass(String name, BundleClassLoader classLoader, BundleData data) throws ClassNotFoundException {
        return null;
    }

    public String postFindLibrary(String name, BundleClassLoader classLoader, BundleData data) {
        return null;
    }

    public Class<?> preFindClass(String name, BundleClassLoader classLoader, BundleData data) throws ClassNotFoundException {
        return null;
    }

    public String preFindLibrary(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        return null;
    }

    public URL preFindResource(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        return null;
    }

    public Enumeration<URL> preFindResources(String name, BundleClassLoader classLoader, BundleData data) throws FileNotFoundException {
        return null;
    }

    private final class CacheClearingBundleListener
    implements BundleListener {
        private CacheClearingBundleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            if (64 == event.getType()) {
                Object object = MetaInfResourceClassLoaderDelegateHook.this.monitor;
                synchronized (object) {
                    MetaInfResourceClassLoaderDelegateHook.this.dependenciesCache.remove(event.getBundle());
                }
            }
        }
    }

    private static class IteratorEnumerationAdaptor<T>
    implements Enumeration<T> {
        private final Iterator<T> iterator;

        private IteratorEnumerationAdaptor(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }

    private static final class SecurityManagerExecutionStackAccessor
    extends SecurityManager {
        private SecurityManagerExecutionStackAccessor() {
        }

        public Class<?>[] getExecutionStack() {
            Class<?>[] classes = super.getClassContext();
            Class[] executionStack = new Class[classes.length - 1];
            System.arraycopy(classes, 1, executionStack, 0, executionStack.length);
            return executionStack;
        }
    }
}

