/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.common.KEYS;
import org.eclipse.equinox.console.common.Scanner;
import org.eclipse.equinox.console.common.terminal.TerminalTypeMappings;

public class SshInputScanner
extends Scanner {
    public SshInputScanner(ConsoleInputStream toShell, OutputStream toTelnet) {
        super(toShell, toTelnet);
        TerminalTypeMappings currentMapping = (TerminalTypeMappings)this.supportedEscapeSequences.get(DEFAULT_TTYPE);
        this.currentEscapesToKey = currentMapping.getEscapesToKey();
        this.escapes = currentMapping.getEscapes();
        this.setBackspace(currentMapping.getBackspace());
        this.setDel(currentMapping.getDel());
    }

    public void scan(int b) throws IOException {
        b &= 0xFF;
        if (this.isEsc) {
            this.scanEsc(b);
        } else {
            switch (b) {
                case 27: {
                    this.startEsc();
                    this.toShell.add(new byte[]{(byte)b});
                    break;
                }
                default: {
                    if (b >= 32 && b < 127) {
                        this.echo((byte)b);
                        this.flush();
                    }
                    this.toShell.add(new byte[]{(byte)b});
                }
            }
        }
    }

    protected void scanEsc(int b) throws IOException {
        this.esc = String.valueOf(this.esc) + (char)b;
        this.toShell.add(new byte[]{(byte)b});
        KEYS key = this.checkEscape(this.esc);
        if (key == KEYS.UNFINISHED) {
            return;
        }
        if (key == KEYS.UNKNOWN) {
            this.isEsc = false;
            this.scan(b);
            return;
        }
        this.isEsc = false;
    }
}

