/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TomcatMBeanManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TomcatMBeanManager.class);
    private final String domain;

    public TomcatMBeanManager(String domain) {
        this.domain = domain;
    }

    public void start() {
        this.cleanMBeans();
    }

    public void stop() {
        this.cleanMBeans();
    }

    private void cleanMBeans() {
        Set<ObjectName> mbeans = this.findTomcatObjectNames();
        for (ObjectName objectName : mbeans) {
            this.tryUnregister(objectName);
        }
    }

    private void tryUnregister(ObjectName objectName) {
        block4: {
            try {
                this.getMBeanServer().unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Attempted to unregister MBean that was not registered '" + objectName + "'");
                }
            }
            catch (MBeanRegistrationException e) {
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn("Error unregistering MBean '" + objectName + "'", (Throwable)e);
            }
        }
    }

    private Set<ObjectName> findTomcatObjectNames() {
        ObjectName tomcatPattern;
        try {
            tomcatPattern = new ObjectName(String.valueOf(this.domain) + ":*");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unable to create query pattern.", e);
        }
        return this.getMBeanServer().queryNames(tomcatPattern, null);
    }

    private MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

