/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.ApplicationBufferHandler;

public class SavedRequestInputFilter
implements InputFilter {
    protected ByteChunk input = null;

    public SavedRequestInputFilter(ByteChunk input) {
        this.input = input;
    }

    @Override
    @Deprecated
    public int doRead(ByteChunk chunk) throws IOException {
        if (this.input.getOffset() >= this.input.getEnd()) {
            return -1;
        }
        int writeLength = 0;
        writeLength = chunk.getLimit() > 0 && chunk.getLimit() < this.input.getLength() ? chunk.getLimit() : this.input.getLength();
        this.input.substract(chunk.getBuffer(), 0, writeLength);
        chunk.setOffset(0);
        chunk.setEnd(writeLength);
        return writeLength;
    }

    @Override
    public int doRead(ApplicationBufferHandler handler) throws IOException {
        if (this.input.getOffset() >= this.input.getEnd()) {
            return -1;
        }
        ByteBuffer byteBuffer = handler.getByteBuffer();
        byteBuffer.position(byteBuffer.limit()).limit(byteBuffer.capacity());
        this.input.substract(byteBuffer);
        return byteBuffer.remaining();
    }

    @Override
    public void setRequest(Request request) {
        request.setContentLength(this.input.getLength());
    }

    @Override
    public void recycle() {
        this.input = null;
    }

    @Override
    public ByteChunk getEncodingName() {
        return null;
    }

    @Override
    public void setBuffer(InputBuffer buffer) {
    }

    @Override
    public int available() {
        return this.input.getLength();
    }

    @Override
    public long end() throws IOException {
        return 0L;
    }

    @Override
    public boolean isFinished() {
        return this.input.getOffset() >= this.input.getEnd();
    }
}

