/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal.commandline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.diagnostics.KernelLogEvents;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.osgi.framework.BundleContext;

public final class CommandLinePropertiesSource
implements PropertiesSource {
    private static final String PROPERTY_USERREGION_COMMANDLINE_ARTIFACTS = "commandLineArtifacts";
    private static final String PROPERTY_UNRECOGNIZED_LAUNCHER_ARGUMENTS = "eclipse.commands";
    private static final String COMMAND_PREFIX = "-";
    private static final String COMMAND_PLAN = "plan";
    private static final String PID_KERNEL_REGION = "org.eclipse.virgo.kernel.userregion";
    private static final String TEMPLATE_VERSIONED_PLAN_REPOSITORY_URI = "repository:plan/%s/%s";
    private static final String TEMPLATE_UNVERSIONED_PLAN_REPOSITORY_URI = "repository:plan/%s";
    private final String unrecognizedArguments;
    private final EventLogger eventLogger;

    public CommandLinePropertiesSource(BundleContext bundleContext, EventLogger eventLogger) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.unrecognizedArguments = bundleContext.getProperty(PROPERTY_UNRECOGNIZED_LAUNCHER_ARGUMENTS);
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public Map<String, Properties> getConfigurationProperties() {
        try {
            HashMap<String, Properties> configuration = new HashMap<String, Properties>();
            if (this.unrecognizedArguments != null) {
                String[] components = this.unrecognizedArguments.split("\n");
                ArrayList<String> arguments = null;
                String command = null;
                int i = 0;
                while (i < components.length) {
                    if (components[i].startsWith(COMMAND_PREFIX)) {
                        if (command != null) {
                            this.processCommand(command, arguments, configuration);
                        }
                        command = components[i].substring(COMMAND_PREFIX.length());
                        arguments = new ArrayList<String>();
                    } else if (arguments != null) {
                        arguments.add(components[i]);
                    }
                    ++i;
                }
                if (command != null) {
                    this.processCommand(command, arguments, configuration);
                }
            }
            return configuration;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void processCommand(String command, List<String> arguments, Map<String, Properties> configuration) {
        try {
            if (COMMAND_PLAN.equals(command)) {
                this.processPlanCommand(arguments, configuration);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void processPlanCommand(List<String> arguments, Map<String, Properties> configuration) {
        try {
            String repositoryUri = null;
            if (arguments.size() == 1) {
                repositoryUri = String.format(TEMPLATE_UNVERSIONED_PLAN_REPOSITORY_URI, arguments.get(0));
            } else if (arguments.size() == 2) {
                repositoryUri = String.format(TEMPLATE_VERSIONED_PLAN_REPOSITORY_URI, arguments.get(0), arguments.get(1));
            } else {
                this.eventLogger.log((LogEvent)KernelLogEvents.KERNEL_PLAN_ARGUMENTS_INCORRECT, new Object[]{arguments.size(), this.formatArgumentList(arguments)});
            }
            if (repositoryUri != null) {
                Properties properties = this.getProperties(PID_KERNEL_REGION, configuration);
                this.appendProperty(PROPERTY_USERREGION_COMMANDLINE_ARTIFACTS, repositoryUri, properties);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String formatArgumentList(List<String> arguments) {
        try {
            if (arguments.size() == 0) {
                return "";
            }
            StringBuilder argumentsBuilder = new StringBuilder();
            int i = 0;
            while (i < arguments.size()) {
                argumentsBuilder.append(arguments.get(i));
                if (i + 1 < arguments.size()) {
                    argumentsBuilder.append(", ");
                }
                ++i;
            }
            return argumentsBuilder.toString();
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Properties getProperties(String pid, Map<String, Properties> configuration) {
        try {
            Properties properties = configuration.get(pid);
            if (properties == null) {
                properties = new Properties();
                configuration.put(pid, properties);
            }
            return properties;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void appendProperty(String key, String value, Properties properties) {
        try {
            String property = properties.getProperty(key);
            property = property != null ? String.valueOf(property) + "," + value : value;
            properties.put(key, property);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

