/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.config.internal;

import java.io.IOException;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.nano.config.internal.ConfigurationAdminDumpContributor;
import org.eclipse.virgo.nano.config.internal.ConfigurationPublisher;
import org.eclipse.virgo.nano.config.internal.ConsoleConfigurationConvertor;
import org.eclipse.virgo.nano.config.internal.KernelConfiguration;
import org.eclipse.virgo.nano.config.internal.KernelConfigurationPropertiesSource;
import org.eclipse.virgo.nano.config.internal.PropertiesSource;
import org.eclipse.virgo.nano.config.internal.UserConfigurationPropertiesSource;
import org.eclipse.virgo.nano.config.internal.commandline.CommandLinePropertiesSource;
import org.eclipse.virgo.nano.config.internal.ovf.OvfPropertiesSource;
import org.eclipse.virgo.nano.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;

public final class ConfigurationInitialiser {
    private final ServiceRegistrationTracker tracker;
    private ConsoleConfigurationConvertor consoleConfigurationConvertor;

    public ConfigurationInitialiser() {
        try {
            this.tracker = new ServiceRegistrationTracker();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public KernelConfiguration start(BundleContext context, EventLogger eventLogger) throws IOException {
        try {
            ServiceReference configurationAdminReference = context.getServiceReference(ConfigurationAdmin.class);
            ConfigurationAdmin configAdmin = null;
            if (configurationAdminReference != null) {
                configAdmin = (ConfigurationAdmin)context.getService(configurationAdminReference);
            }
            if (configAdmin == null) {
                throw new IllegalStateException("ConfigurationAdmin service missing");
            }
            KernelConfiguration configuration = new KernelConfiguration(context);
            this.publishConfiguration(context, eventLogger, configuration, configAdmin);
            this.initializeDumpContributor(context, configAdmin);
            this.initializeConsoleConfigurationConvertor(context, configAdmin);
            return configuration;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void publishConfiguration(BundleContext context, EventLogger eventLogger, KernelConfiguration configuration, ConfigurationAdmin configAdmin) throws IOException {
        try {
            PropertiesSource[] sources = new PropertiesSource[]{new UserConfigurationPropertiesSource(configuration.getConfigDirectories()), new OvfPropertiesSource(context, eventLogger), new KernelConfigurationPropertiesSource(configuration), new CommandLinePropertiesSource(context, eventLogger)};
            ConfigurationPublisher configPublisher = new ConfigurationPublisher(configAdmin, sources);
            configPublisher.publishConfigurations();
            configPublisher.registerConfigurationExporterService(context);
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void initializeDumpContributor(BundleContext context, ConfigurationAdmin configAdmin) {
        try {
            ConfigurationAdminDumpContributor dumpContributor = new ConfigurationAdminDumpContributor(configAdmin);
            this.tracker.track(context.registerService(DumpContributor.class.getName(), (Object)dumpContributor, null));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void initializeConsoleConfigurationConvertor(BundleContext context, ConfigurationAdmin configAdmin) {
        try {
            this.consoleConfigurationConvertor = new ConsoleConfigurationConvertor(context, configAdmin);
            this.consoleConfigurationConvertor.start();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void stop() {
        try {
            this.tracker.unregisterAll();
            this.consoleConfigurationConvertor.stop();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_nano_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

