/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.virgo.util.common.Assert;
import org.eclipse.virgo.util.common.IterableEnumeration;
import org.eclipse.virgo.util.common.StringUtils;
import org.eclipse.virgo.util.io.FatalIOException;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.io.PathReference;

public class ZipUtils {
    private static final String ZIP_FILENAME_SUFFIX = ".zip";
    private static final int BUFFER_SIZE = 2048;

    public static PathReference unzipTo(PathReference zipFile, PathReference dest) throws IOException {
        return ZipUtils.unzipToFolder(zipFile, dest, false);
    }

    public static PathReference unzipToDestructive(PathReference zipFile, PathReference dest) throws IOException {
        return ZipUtils.unzipToFolder(zipFile, dest, true);
    }

    public static PathReference zipTo(PathReference toZip, PathReference dest) throws IOException {
        Assert.isTrue((boolean)toZip.exists(), (String)"Supplied file or directory '%s' must exist", (Object[])new Object[]{toZip});
        PathReference finalDest = ZipUtils.determineFinalZipDestination(toZip, dest);
        try (ZipOutputStream zos = null;){
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(finalDest.toFile())));
            ZipUtils.doZip(zos, toZip.toFile(), toZip.toFile(), null);
        }
        return finalDest;
    }

    public static PathReference zipTo(PathReference toZip, PathReference dest, String entryPrefix) throws IOException {
        Assert.isTrue((boolean)toZip.exists(), (String)"Supplied file or directory '%s' must exist", (Object[])new Object[]{toZip});
        PathReference finalDest = ZipUtils.determineFinalZipDestination(toZip, dest);
        try (ZipOutputStream zos = null;){
            zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(finalDest.toFile())));
            ZipUtils.doZip(zos, toZip.toFile(), toZip.toFile(), entryPrefix);
        }
        return finalDest;
    }

    private static PathReference unzipToFolder(PathReference zipFile, PathReference dest, boolean isDestructive) throws IOException {
        Assert.isTrue((boolean)zipFile.exists(), (String)"Supplied file '%s' must exist", (Object[])new Object[]{zipFile});
        PathReference finalDest = ZipUtils.determineFinalUnzipDestination(zipFile, dest, isDestructive);
        try (ZipFile zip = null;){
            zip = new ZipFile(zipFile.toFile());
            for (ZipEntry entry : new IterableEnumeration(zip.entries())) {
                PathReference entryPath = finalDest.newChild(entry.getName());
                if (entry.isDirectory()) {
                    entryPath.createDirectory();
                    continue;
                }
                PathReference filePath = entryPath.createFile();
                InputStream inputStream = zip.getInputStream(entry);
                FileCopyUtils.copy(inputStream, (OutputStream)new FileOutputStream(filePath.toFile()));
            }
        }
        return finalDest;
    }

    private static void doZip(ZipOutputStream zos, File file, File root, String entryPrefix) throws IOException {
        byte[] data = new byte[2048];
        String entryName = ZipUtils.determineNameOfEntry(file, root, entryPrefix);
        if (file.isDirectory()) {
            if (!file.equals(root)) {
                ZipEntry entry = new ZipEntry(entryName);
                zos.putNextEntry(entry);
                zos.closeEntry();
            }
            File[] fileArray = FileSystemUtils.listFiles(file);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File dirFile = fileArray[n2];
                ZipUtils.doZip(zos, dirFile, root, entryPrefix);
                ++n2;
            }
        } else {
            try (InputStream is = null;){
                int count;
                ZipEntry entry = new ZipEntry(entryName);
                zos.putNextEntry(entry);
                is = new BufferedInputStream(new FileInputStream(file));
                while ((count = is.read(data)) > 0) {
                    zos.write(data, 0, count);
                }
                zos.closeEntry();
            }
        }
    }

    private static String determineNameOfEntry(File file, File root, String entryPrefix) {
        String fileName = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        String entryName = entryPrefix == null ? fileName : String.valueOf(entryPrefix) + fileName;
        if (file.isDirectory() && !entryName.endsWith("/")) {
            entryName = String.valueOf(entryName) + "/";
        }
        return entryName;
    }

    private static PathReference determineFinalUnzipDestination(PathReference zipFile, PathReference dest, boolean isDestructive) {
        PathReference finalDest = dest;
        if (!dest.exists()) {
            dest.createDirectory();
        } else if (dest.isDirectory()) {
            if (isDestructive) {
                boolean isDeleted = dest.delete(true);
                if (!isDeleted) {
                    throw new FatalIOException("Content of destination path '" + dest + "' cannot be removed");
                }
                dest.createDirectory();
            } else {
                String destDir = StringUtils.stripFilenameExtension((String)StringUtils.getFilename((String)zipFile.getName()));
                finalDest = dest.newChild(destDir).createDirectory();
            }
        } else {
            throw new FatalIOException("Destination path '" + dest + "' already exists and is not a directory");
        }
        return finalDest;
    }

    private static PathReference determineFinalZipDestination(PathReference toZip, PathReference dest) {
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                throw new FatalIOException("Destination path '" + dest + "' already exists and is not a directory");
            }
            return dest.newChild(String.valueOf(toZip.getName()) + ZIP_FILENAME_SUFFIX);
        }
        return dest;
    }
}

