/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.eclipse.virgo.util.io.FatalIOException;
import org.eclipse.virgo.util.io.FileCopyUtils;
import org.eclipse.virgo.util.io.FileSystemUtils;

public final class PathReference {
    private final File file;

    public PathReference(String path) {
        this(new File(path));
    }

    public PathReference(URI uri) {
        this.file = new File(uri);
    }

    public PathReference(File file) {
        this.file = file;
    }

    public File toFile() {
        return this.file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public String getName() {
        return this.file.getName();
    }

    public PathReference getParent() {
        File parentFile = this.file.getParentFile();
        return parentFile == null ? null : new PathReference(parentFile);
    }

    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public URI toURI() {
        return this.file.toURI();
    }

    public String getCanonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new FatalIOException("Unable to canonicalize path for file '" + this + "'.", e);
        }
    }

    public PathReference toAbsoluteReference() {
        return new PathReference(this.getAbsolutePath());
    }

    public PathReference toCanonicalReference() {
        return new PathReference(this.getCanonicalPath());
    }

    public String toString() {
        return this.file.toString();
    }

    public boolean delete() {
        return this.delete(false);
    }

    public boolean delete(boolean recursive) {
        boolean deleted = recursive ? FileSystemUtils.deleteRecursively(this.file) : this.file.delete();
        return deleted;
    }

    public PathReference copy(PathReference dest) {
        return this.copy(dest, false);
    }

    public PathReference copy(PathReference dest, boolean recursive) {
        return this.copy(dest, recursive, null);
    }

    public PathReference copy(PathReference dest, boolean recursive, PathFilter filter) {
        if (!this.exists()) {
            throw new FatalIOException("Cannot copy path '" + this + "' to '" + dest + "'. Source path does not exist.");
        }
        if (this.isFile()) {
            if (dest.exists()) {
                if (dest.isFile()) {
                    throw new FatalIOException("Cannot copy path '" + this + "' to '" + dest + "'. Destination path already exists.");
                }
                if ((dest = dest.newChild(this.file.getName())).exists()) {
                    throw new FatalIOException("Cannot copy path '" + this + "' to '" + dest + "'. Destination path already exists.");
                }
                dest.createFile();
            }
            PathReference.copyFile(this.file, dest.file);
        } else {
            int length = FileSystemUtils.list(this.file).length;
            if (length > 0 && !recursive) {
                throw new FatalIOException("Cannot perform non-recursive copy on non-empty directory '" + this + "'");
            }
            if (dest.exists()) {
                dest = dest.newChild(this.file.getName()).createDirectory();
            } else {
                dest.createDirectory();
            }
            PathReference.recursiveCopy(this.file, dest.file, filter);
        }
        return dest;
    }

    public PathReference moveTo(PathReference dest) {
        if (!this.exists()) {
            throw new FatalIOException("Cannot move path '" + this + "' to '" + dest + "'. Source file does not exist.");
        }
        if (dest.exists()) {
            throw new FatalIOException("Cannot move path '" + this + "' to '" + dest + "'. Destination path already exists.");
        }
        if (!this.file.renameTo(dest.file)) {
            this.copy(dest, true);
            this.delete(true);
        }
        return dest;
    }

    PathReference fastMoveTo(PathReference dest) {
        if (!this.exists()) {
            throw new FatalIOException("Cannot move path '" + this + "' to '" + dest + "'. Source file does not exist.");
        }
        if (dest.exists()) {
            throw new FatalIOException("Cannot move path '" + this + "' to '" + dest + "'. Destination path already exists.");
        }
        if (!this.file.renameTo(dest.file)) {
            throw new FatalIOException("Fast move from '" + this + "' to '" + dest + "' failed.");
        }
        return dest;
    }

    public PathReference newChild(String name) {
        return PathReference.concat(this.file.getPath(), name);
    }

    public PathReference createFile() {
        boolean success;
        if (this.exists()) {
            return this;
        }
        File parent = this.file.getParentFile();
        if (!parent.exists() && !(success = parent.mkdirs())) {
            throw new FatalIOException("Unable to create needed directory " + parent);
        }
        try {
            this.file.createNewFile();
            return this;
        }
        catch (IOException e) {
            throw new FatalIOException("Unable to create file '" + this + "'.", e);
        }
    }

    public PathReference createDirectory() {
        if (!this.file.exists() && !this.file.mkdirs()) {
            throw new FatalIOException("Unable to create directory " + this.file);
        }
        return this;
    }

    public static PathReference concat(String ... parts) {
        StringBuilder sb = new StringBuilder(256);
        int x = 0;
        while (x < parts.length) {
            String part = parts[x];
            sb.append(part);
            if (x < parts.length && !part.endsWith(File.separator)) {
                sb.append(File.separatorChar);
            }
            ++x;
        }
        return new PathReference(sb.toString());
    }

    private static void recursiveCopy(File src, File dest, PathFilter filter) {
        File[] fileArray = FileSystemUtils.listFiles(src);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            PathReference newFile = PathReference.concat(dest.getAbsolutePath(), file.getName());
            if (filter == null || filter.matches(new PathReference(file))) {
                if (file.isFile()) {
                    newFile.createFile();
                    PathReference.copyFile(file, newFile.toFile());
                } else {
                    newFile.createDirectory();
                    PathReference.recursiveCopy(file, newFile.toFile(), filter);
                }
            }
            ++n2;
        }
    }

    private static void copyFile(File src, File dest) {
        try {
            FileCopyUtils.copy(src, dest);
        }
        catch (IOException e) {
            throw new FatalIOException("Cannot copy " + (src.isFile() ? "file" : "directory") + " '" + src + "' to '" + dest + "'.", e);
        }
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof PathReference)) {
            return false;
        }
        PathReference thatRef = (PathReference)that;
        return this.file.equals(thatRef.file);
    }

    public String fileContents() throws IOException {
        if (!this.file.isFile()) {
            throw new FileNotFoundException("PathReference refers to a directory which has no file contents");
        }
        StringBuffer contents = new StringBuffer(100);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));){
            char[] chars = new char[100];
            int charsRead = 0;
            while ((charsRead = fileReader.read(chars)) != -1) {
                contents.append(chars, 0, charsRead);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return contents.toString();
    }

    public boolean touch() {
        return this.file.setLastModified(System.currentTimeMillis());
    }

    public static interface PathFilter {
        public boolean matches(PathReference var1);
    }
}

