/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.RepositoryUtils;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;

public interface Query {
    public Query addFilter(String var1, String var2);

    public Query addFilter(String var1, String var2, Map<String, Set<String>> var3);

    public Query setVersionRangeFilter(VersionRange var1);

    public Query setVersionRangeFilter(VersionRange var1, VersionRangeMatchingStrategy var2);

    public Set<RepositoryAwareArtifactDescriptor> run();

    public static enum VersionRangeMatchingStrategy {
        ALL{

            @Override
            public <T extends ArtifactDescriptor> Set<T> match(Set<T> unfiltered, VersionRange versionRange) {
                return unfiltered;
            }
        }
        ,
        HIGHEST{

            @Override
            public <T extends ArtifactDescriptor> Set<T> match(Set<T> unfiltered, VersionRange versionRange) {
                HashSet<T> result = new HashSet<T>();
                Set<Set<T>> grouped = RepositoryUtils.groupByTypeAndName(unfiltered);
                for (Set<T> group : grouped) {
                    result.add(RepositoryUtils.selectHighestVersionInRange(group, versionRange));
                }
                return result;
            }
        }
        ,
        LOWEST{

            @Override
            public <T extends ArtifactDescriptor> Set<T> match(Set<T> unfiltered, VersionRange versionRange) {
                HashSet<T> result = new HashSet<T>();
                Set<Set<T>> grouped = RepositoryUtils.groupByTypeAndName(unfiltered);
                for (Set<T> group : grouped) {
                    result.add(RepositoryUtils.selectLowestVersionInRange(group, versionRange));
                }
                return result;
            }
        };


        public abstract <T extends ArtifactDescriptor> Set<T> match(Set<T> var1, VersionRange var2);
    }
}

