/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal.bundle;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.InstallArtifactRefreshHandler;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStateMonitor;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.BundleDriverFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleDriver;
import org.eclipse.virgo.kernel.install.artifact.internal.bundle.StandardBundleInstallArtifact;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

final class BundleInstallArtifactFactory {
    private static final Version DEFAULT_BUNDLE_VERSION = Version.emptyVersion;
    private final BundleContext kernelBundleContext;
    private final InstallArtifactRefreshHandler refreshHandler;
    private final BundleDriverFactory bundleDriverFactory;
    private final EventLogger eventLogger;
    private final ArtifactIdentityDeterminer identityDeterminer;

    BundleInstallArtifactFactory(BundleContext kernelBundleContext, InstallArtifactRefreshHandler refreshHandler, BundleDriverFactory bundleDriverFactory, EventLogger eventLogger, ArtifactIdentityDeterminer identityDeterminer) {
        this.kernelBundleContext = kernelBundleContext;
        this.refreshHandler = refreshHandler;
        this.bundleDriverFactory = bundleDriverFactory;
        this.eventLogger = eventLogger;
        this.identityDeterminer = identityDeterminer;
    }

    BundleInstallArtifact createBundleInstallArtifact(ArtifactIdentity identity, ArtifactStorage artifactStorage, String repositoryName) throws DeploymentException {
        StandardArtifactStateMonitor artifactStateMonitor = new StandardArtifactStateMonitor(this.kernelBundleContext);
        StandardBundleDriver bundleDriver = this.bundleDriverFactory.createBundleDriver(identity, artifactStateMonitor);
        BundleManifest bundleManifest = this.retrieveArtifactFSManifest(artifactStorage.getArtifactFS());
        StandardBundleInstallArtifact bundleInstallArtifact = new StandardBundleInstallArtifact(identity, bundleManifest, artifactStorage, bundleDriver, artifactStateMonitor, this.refreshHandler, repositoryName, this.eventLogger, this.identityDeterminer);
        bundleDriver.setInstallArtifact(bundleInstallArtifact);
        return bundleInstallArtifact;
    }

    private BundleManifest retrieveArtifactFSManifest(ArtifactFS artifactFS) throws DeploymentException {
        ArtifactFSEntry manifestEntry = artifactFS.getEntry("META-INF/MANIFEST.MF");
        if (manifestEntry != null && manifestEntry.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStreamReader manifestReader = new InputStreamReader(manifestEntry.getInputStream(), StandardCharsets.UTF_8);){
                    return BundleManifestFactory.createBundleManifest((Reader)manifestReader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioe) {
                throw new DeploymentException("Failed to read manifest for bundle from " + artifactFS, (Throwable)ioe);
            }
        }
        return BundleManifestFactory.createBundleManifest();
    }

    static Version getVersionFromManifest(BundleManifest bundleManifest) {
        Version version = bundleManifest.getBundleVersion();
        return version == null ? DEFAULT_BUNDLE_VERSION : version;
    }

    private static String getNameFromManifest(BundleManifest bundleManifest) {
        return bundleManifest.getBundleSymbolicName().getSymbolicName();
    }

    static String determineName(BundleManifest bundleManifest, ArtifactFS artifactFS) {
        String name = BundleInstallArtifactFactory.getNameFromManifest(bundleManifest);
        if (name == null) {
            name = artifactFS.getFile().getName();
        }
        return name;
    }
}

