/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.kernel.install.artifact.ArtifactState;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifactLifecycleListener;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class StandardArtifactStateMonitor
implements ArtifactStateMonitor {
    private static final ArrayList<OsgiServiceHolder<InstallArtifactLifecycleListener>> EMPTY_LISTENER_HOLDER_LIST = new ArrayList();
    private final BundleContext bundleContext;
    private final Bundle bundle;
    private final ArtifactState artifactState;

    private StandardArtifactStateMonitor(BundleContext bundleContext, ArtifactState artifactState) {
        this.bundleContext = bundleContext;
        this.bundle = this.bundleContext.getBundle();
        this.artifactState = artifactState;
    }

    public StandardArtifactStateMonitor(BundleContext bundleContext) {
        this(bundleContext, new ArtifactState());
    }

    @Override
    public InstallArtifact.State getState() {
        return this.artifactState.getState();
    }

    @Override
    public void setState(InstallArtifact.State state) {
        switch (state) {
            case ACTIVE: {
                this.artifactState.setActive();
                break;
            }
            case INITIAL: {
                this.artifactState.setInitial();
                break;
            }
            case INSTALLED: {
                this.artifactState.setInstalled();
                break;
            }
            case INSTALLING: {
                this.artifactState.setInstalling();
                break;
            }
            case RESOLVED: {
                this.artifactState.setResolved();
                break;
            }
            case RESOLVING: {
                this.artifactState.setResolving();
                break;
            }
            case STARTING: {
                this.artifactState.setStarting();
                break;
            }
            case STOPPING: {
                this.artifactState.setStopping();
                break;
            }
            case UNINSTALLED: {
                this.artifactState.setUninstalled();
                break;
            }
            case UNINSTALLING: {
                this.artifactState.setUninstalling();
            }
        }
    }

    @Override
    public void onInstalling(InstallArtifact installArtifact) throws DeploymentException {
        InstallArtifact.State state = this.artifactState.getState();
        if (state.equals((Object)InstallArtifact.State.INITIAL) && this.artifactState.setInstalling()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onInstalling(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onInstallFailed(InstallArtifact installArtifact) throws DeploymentException {
        InstallArtifact.State state = this.artifactState.getState();
        if (state.equals((Object)InstallArtifact.State.INSTALLING) && this.artifactState.setInitial()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onInstallFailed(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onInstalled(InstallArtifact installArtifact) throws DeploymentException {
        InstallArtifact.State state = this.artifactState.getState();
        if ((state.equals((Object)InstallArtifact.State.INITIAL) || state.equals((Object)InstallArtifact.State.INSTALLING)) && this.artifactState.setInstalled()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onInstalled(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onResolving(InstallArtifact installArtifact) throws DeploymentException {
        InstallArtifact.State state = this.artifactState.getState();
        if ((state.equals((Object)InstallArtifact.State.INITIAL) || state.equals((Object)InstallArtifact.State.INSTALLING) || state.equals((Object)InstallArtifact.State.INSTALLED)) && this.artifactState.setResolving()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onResolving(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onResolveFailed(InstallArtifact installArtifact) throws DeploymentException {
        InstallArtifact.State state = this.artifactState.getState();
        if ((state.equals((Object)InstallArtifact.State.INITIAL) || state.equals((Object)InstallArtifact.State.INSTALLING) || state.equals((Object)InstallArtifact.State.INSTALLED) || state.equals((Object)InstallArtifact.State.RESOLVING) || state.equals((Object)InstallArtifact.State.STOPPING)) && this.artifactState.setInstalled()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onResolveFailed(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onResolved(InstallArtifact installArtifact) throws DeploymentException {
        InstallArtifact.State state = this.artifactState.getState();
        if ((state.equals((Object)InstallArtifact.State.INITIAL) || state.equals((Object)InstallArtifact.State.INSTALLING) || state.equals((Object)InstallArtifact.State.INSTALLED) || state.equals((Object)InstallArtifact.State.RESOLVING) || state.equals((Object)InstallArtifact.State.STOPPING)) && this.artifactState.setResolved()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onResolved(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public boolean onStarting(InstallArtifact installArtifact) throws DeploymentException {
        boolean stateChanged = this.artifactState.setStarting();
        if (stateChanged) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onStarting(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
        return stateChanged;
    }

    @Override
    public void onStartFailed(InstallArtifact installArtifact, Throwable cause) throws DeploymentException {
        List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
        try {
            for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                listener.onStartFailed(installArtifact, cause);
            }
        }
        finally {
            this.ungetListeners(listenerHolders);
        }
    }

    @Override
    public void onStartAborted(InstallArtifact installArtifact) throws DeploymentException {
        List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
        try {
            for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                listener.onStartAborted(installArtifact);
            }
        }
        finally {
            this.ungetListeners(listenerHolders);
        }
    }

    @Override
    public void onStarted(InstallArtifact installArtifact) throws DeploymentException {
        if (this.artifactState.setActive()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onStarted(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onStopping(InstallArtifact installArtifact) {
        if (this.artifactState.setStopping()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onStopping(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onStopFailed(InstallArtifact installArtifact, Throwable cause) throws DeploymentException {
        if (this.artifactState.setActive()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onStopFailed(installArtifact, cause);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onStopped(InstallArtifact installArtifact) {
        if (this.artifactState.setResolved()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onStopped(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onUnresolved(InstallArtifact installArtifact) throws DeploymentException {
        if (this.artifactState.setInstalled()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onUnresolved(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onUninstalling(InstallArtifact installArtifact) throws DeploymentException {
        if (this.artifactState.setUninstalling()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onUninstalling(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onUninstallFailed(InstallArtifact installArtifact, Throwable cause) throws DeploymentException {
        if (this.artifactState.setResolved()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onUninstallFailed(installArtifact, cause);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    @Override
    public void onUninstalled(InstallArtifact installArtifact) throws DeploymentException {
        if (this.artifactState.setUninstalled()) {
            List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders = this.getListenerHolders();
            try {
                for (InstallArtifactLifecycleListener listener : this.getListeners(listenerHolders)) {
                    listener.onUninstalled(installArtifact);
                }
            }
            finally {
                this.ungetListeners(listenerHolders);
            }
        }
    }

    private List<OsgiServiceHolder<InstallArtifactLifecycleListener>> getListenerHolders() {
        return this.bundle.getState() != 4 ? OsgiFrameworkUtils.getServices((BundleContext)this.bundleContext, InstallArtifactLifecycleListener.class) : EMPTY_LISTENER_HOLDER_LIST;
    }

    private List<InstallArtifactLifecycleListener> getListeners(List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders) {
        ArrayList<InstallArtifactLifecycleListener> listeners = new ArrayList<InstallArtifactLifecycleListener>(listenerHolders.size());
        for (OsgiServiceHolder<InstallArtifactLifecycleListener> listenerHolder : listenerHolders) {
            listeners.add((InstallArtifactLifecycleListener)listenerHolder.getService());
        }
        return listeners;
    }

    private void ungetListeners(List<OsgiServiceHolder<InstallArtifactLifecycleListener>> listenerHolders) {
        for (OsgiServiceHolder<InstallArtifactLifecycleListener> listenerHolder : listenerHolders) {
            this.bundleContext.ungetService(listenerHolder.getServiceReference());
        }
    }
}

