/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.container;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.virgo.snaps.core.internal.SnapException;
import org.eclipse.virgo.snaps.core.internal.webapp.ImmutableServletConfig;
import org.eclipse.virgo.snaps.core.internal.webapp.SnapServletContext;
import org.eclipse.virgo.snaps.core.internal.webapp.config.ServletDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.ServletMappingDefinition;
import org.eclipse.virgo.snaps.core.internal.webapp.config.WebXml;
import org.eclipse.virgo.snaps.core.internal.webapp.container.ManagerUtils;
import org.eclipse.virgo.snaps.core.internal.webapp.container.ServletHolder;
import org.eclipse.virgo.snaps.core.internal.webapp.url.Mapping;
import org.eclipse.virgo.snaps.core.internal.webapp.url.UrlPatternMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServletManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<SnapServletContext> snapServletContexts = new ArrayList<SnapServletContext>();
    private final ClassLoader classLoader;
    private final UrlPatternMatcher patternMatcher = new UrlPatternMatcher();
    private final Map<String, ServletHolder> servlets = new ConcurrentHashMap<String, ServletHolder>();
    private WebXml webXml;

    ServletManager(WebXml webXml, SnapServletContext snapServletContext, ClassLoader classLoader) {
        this.webXml = webXml;
        this.snapServletContexts.add(snapServletContext);
        this.classLoader = classLoader;
        this.reifyWebXml(snapServletContext);
    }

    void init() throws ServletException {
        try {
            ManagerUtils.doWithThreadContextClassLoader(this.classLoader, new ManagerUtils.ClassLoaderCallback<Void>(){

                @Override
                public Void doWithClassLoader() throws ServletException {
                    for (Map.Entry entry : ServletManager.this.servlets.entrySet()) {
                        ServletHolder holder = (ServletHolder)entry.getValue();
                        ImmutableServletConfig config = new ImmutableServletConfig((ServletDefinition)holder.getDefinition(), (ServletContext)ServletManager.this.snapServletContexts.get(0));
                        ((Servlet)holder.getInstance()).init((ServletConfig)config);
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            this.logger.error("Unexpected IOException from servlet init", (Throwable)e);
            throw new ServletException("Unexpected IOException from servlet init", (Throwable)e);
        }
    }

    void destroy() {
        for (Map.Entry<String, ServletHolder> entry : this.servlets.entrySet()) {
            ServletHolder holder = entry.getValue();
            ((Servlet)holder.getInstance()).destroy();
        }
        this.servlets.clear();
    }

    Match findMatch(String servletPath) {
        Mapping mapping = this.patternMatcher.match(servletPath);
        if (mapping != null) {
            ServletHolder servletHolder = this.servlets.get(mapping.getName());
            return new Match((Servlet)servletHolder.getInstance(), mapping);
        }
        return null;
    }

    private void reifyWebXml(SnapServletContext snapServletContext) {
        this.processServlets();
        this.processServletMappingDefinitions(snapServletContext);
    }

    private void processServlets() throws SnapException {
        ServletDefinition[] servletDefinitionArray = this.webXml.getServletDefinitions();
        int n = servletDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServletDefinition servletDefinition = servletDefinitionArray[n2];
            try {
                Class<?> servletClass = ManagerUtils.loadComponentClass(servletDefinition.getServletClassName(), this.classLoader);
                Servlet servlet = (Servlet)servletClass.newInstance();
                this.servlets.put(servletDefinition.getServletName(), new ServletHolder(servletDefinition, servlet));
            }
            catch (ClassNotFoundException e) {
                this.logger.error(String.format("The servlet class '%s' could not be loaded by '%s'", servletDefinition.getServletClassName(), this.classLoader), (Throwable)e);
                throw new SnapException("The servlet class '" + servletDefinition.getServletClassName() + "' could not be loaded by " + this.classLoader, e);
            }
            catch (InstantiationException e) {
                this.logger.error(String.format("The servlet class '%s' could not be instantiated", servletDefinition.getServletClassName()), (Throwable)e);
                throw new SnapException("The servlet class '" + servletDefinition.getServletClassName() + "' could not be instantiated", e);
            }
            catch (IllegalAccessException e) {
                this.logger.error(String.format("The servlet class '%s' could not be instantiated due to access restrictions", servletDefinition.getServletClassName()), (Throwable)e);
                throw new SnapException("The servlet class '" + servletDefinition.getServletClassName() + "' could not be instantiated due to access restrictions", e);
            }
            ++n2;
        }
    }

    private void processServletMappingDefinitions(SnapServletContext snapServletContext) {
        ServletMappingDefinition[] servletMappingDefinitionArray = this.webXml.getServletMappingDefinitions();
        int n = servletMappingDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServletMappingDefinition mappingDefinition = servletMappingDefinitionArray[n2];
            this.patternMatcher.addMapping(mappingDefinition.getServletName(), ManagerUtils.expandMapping(mappingDefinition.getUrlPattern(), snapServletContext));
            ++n2;
        }
    }

    public void addSnapServletContext(SnapServletContext snapServletContext) {
        this.snapServletContexts.add(snapServletContext);
        this.processServletMappingDefinitions(snapServletContext);
    }

    static class Match {
        private final Servlet servlet;
        private final Mapping mapping;

        public Match(Servlet servlet, Mapping mapping) {
            this.servlet = servlet;
            this.mapping = mapping;
        }

        public Servlet getServlet() {
            return this.servlet;
        }

        public Mapping getMapping() {
            return this.mapping;
        }
    }
}

