/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceDelegate;
import org.eclipse.virgo.kernel.services.concurrent.KernelScheduledExecutorService;
import org.eclipse.virgo.kernel.services.concurrent.ThreadPoolUtils;
import org.eclipse.virgo.nano.shim.serviceability.TracingService;

public final class KernelScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements KernelScheduledExecutorService {
    private final ExecutorServiceDelegate delegate;
    private final String poolName;

    public KernelScheduledThreadPoolExecutor(int corePoolSize, String poolName, TracingService tracingService) {
        this(corePoolSize, poolName, tracingService, null);
    }

    public KernelScheduledThreadPoolExecutor(int corePoolSize, String poolName, TracingService tracingService, RejectedExecutionHandler handler) {
        super(corePoolSize, ThreadPoolUtils.createThreadFactory(poolName), ThreadPoolUtils.determineHandler(handler));
        this.poolName = poolName;
        this.delegate = new ExecutorServiceDelegate(tracingService);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(this.delegate.decorate(command));
    }

    @Override
    public long getAverageExecutionTime() {
        return this.delegate.getAverageExecutionTime(this.getCompletedTaskCount());
    }

    @Override
    public long getExecutionTime() {
        return this.delegate.getExecutionTime();
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }
}

