/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.config;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.broker.SimpleBrokerMessageHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.SimpleBrokerRegistration;
import org.springframework.messaging.simp.config.StompBrokerRelayRegistration;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;

public class MessageBrokerRegistry {
    private final SubscribableChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private SimpleBrokerRegistration simpleBrokerRegistration;
    private StompBrokerRelayRegistration brokerRelayRegistration;
    private final ChannelRegistration brokerChannelRegistration = new ChannelRegistration();
    private String[] applicationDestinationPrefixes;
    private String userDestinationPrefix;
    private PathMatcher pathMatcher;

    public MessageBrokerRegistry(SubscribableChannel clientInboundChannel, MessageChannel clientOutboundChannel) {
        Assert.notNull((Object)clientInboundChannel);
        Assert.notNull((Object)clientOutboundChannel);
        this.clientInboundChannel = clientInboundChannel;
        this.clientOutboundChannel = clientOutboundChannel;
    }

    public SimpleBrokerRegistration enableSimpleBroker(String ... destinationPrefixes) {
        this.simpleBrokerRegistration = new SimpleBrokerRegistration(this.clientInboundChannel, this.clientOutboundChannel, destinationPrefixes);
        return this.simpleBrokerRegistration;
    }

    public StompBrokerRelayRegistration enableStompBrokerRelay(String ... destinationPrefixes) {
        this.brokerRelayRegistration = new StompBrokerRelayRegistration(this.clientInboundChannel, this.clientOutboundChannel, destinationPrefixes);
        return this.brokerRelayRegistration;
    }

    public ChannelRegistration configureBrokerChannel() {
        return this.brokerChannelRegistration;
    }

    protected ChannelRegistration getBrokerChannelRegistration() {
        return this.brokerChannelRegistration;
    }

    protected String getUserDestinationBroadcast() {
        return this.brokerRelayRegistration != null ? this.brokerRelayRegistration.getUserDestinationBroadcast() : null;
    }

    protected String getUserRegistryBroadcast() {
        return this.brokerRelayRegistration != null ? this.brokerRelayRegistration.getUserRegistryBroadcast() : null;
    }

    public MessageBrokerRegistry setApplicationDestinationPrefixes(String ... prefixes) {
        this.applicationDestinationPrefixes = prefixes;
        return this;
    }

    protected Collection<String> getApplicationDestinationPrefixes() {
        return this.applicationDestinationPrefixes != null ? Arrays.asList(this.applicationDestinationPrefixes) : null;
    }

    public MessageBrokerRegistry setUserDestinationPrefix(String destinationPrefix) {
        this.userDestinationPrefix = destinationPrefix;
        return this;
    }

    protected String getUserDestinationPrefix() {
        return this.userDestinationPrefix;
    }

    public MessageBrokerRegistry setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
        return this;
    }

    protected PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    protected SimpleBrokerMessageHandler getSimpleBroker(SubscribableChannel brokerChannel) {
        if (this.simpleBrokerRegistration == null && this.brokerRelayRegistration == null) {
            this.enableSimpleBroker(new String[0]);
        }
        if (this.simpleBrokerRegistration != null) {
            SimpleBrokerMessageHandler handler = this.simpleBrokerRegistration.getMessageHandler(brokerChannel);
            handler.setPathMatcher(this.pathMatcher);
            return handler;
        }
        return null;
    }

    protected StompBrokerRelayMessageHandler getStompBrokerRelay(SubscribableChannel brokerChannel) {
        if (this.brokerRelayRegistration != null) {
            return this.brokerRelayRegistration.getMessageHandler(brokerChannel);
        }
        return null;
    }
}

