/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework.internal;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.osgi.framework.BundleEvent;
import org.osgi.jmx.framework.BundleStateMBean;

public final class OSGiBundleEvent {
    private long bundleId;
    private int eventType;
    private String location;
    private String symbolicName;

    public OSGiBundleEvent(BundleEvent event) {
        this.bundleId = event.getBundle().getBundleId();
        this.location = event.getBundle().getLocation();
        this.symbolicName = event.getBundle().getSymbolicName();
        this.eventType = event.getType();
    }

    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.bundleId);
        items.put("Location", this.location);
        items.put("SymbolicName", this.symbolicName);
        items.put("BundleEvent", this.eventType);
        try {
            return new CompositeDataSupport(BundleStateMBean.BUNDLE_EVENT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle event open data", e);
        }
    }
}

