/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.internal;

public class BasicReadWriteLock {
    private int currentReaders = 0;
    private int writersWaiting = 0;
    private boolean writing = false;

    public synchronized void readLock() {
        while (this.writing || this.writersWaiting != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        ++this.currentReaders;
    }

    public synchronized void readUnlock() {
        --this.currentReaders;
        this.notifyAll();
    }

    public synchronized void writeLock() {
        ++this.writersWaiting;
        while (this.writing || this.currentReaders != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        --this.writersWaiting;
        this.writing = true;
    }

    public synchronized void writeUnlock() {
        this.writing = false;
        this.notifyAll();
    }
}

