/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectInstance;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.Query;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.configuration.RepositoryConfiguration;
import org.eclipse.virgo.repository.internal.ArtifactDescriptorDepository;
import org.eclipse.virgo.repository.internal.RepositoryUtils;
import org.eclipse.virgo.repository.internal.StandardQuery;
import org.eclipse.virgo.repository.internal.management.RepositoryObjectNameFactory;
import org.eclipse.virgo.repository.management.RepositoryInfo;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRepository
implements Repository {
    private final String mBeanDomain;
    private static final Logger LOGGER;
    private final String name;
    private final ArtifactDescriptorDepository artifactDepository;
    private volatile ObjectInstance mBean;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.BaseRepository");
        LOGGER = LoggerFactory.getLogger(BaseRepository.class);
    }

    protected BaseRepository(RepositoryConfiguration configuration, ArtifactDescriptorDepository artifactDepository) {
        this.name = configuration.getName();
        this.mBeanDomain = configuration.getMBeanDomain();
        this.artifactDepository = artifactDepository;
    }

    protected void start() {
        if (this.mBeanDomain != null) {
            try {
                this.mBean = ManagementFactory.getPlatformMBeanServer().registerMBean(this.createMBean(), RepositoryObjectNameFactory.createObjectName(this.mBeanDomain, this.name));
            }
            catch (JMException jme) {
                LOGGER.warn(String.format("Management Bean for repository '%s' not registered.", this.name), (Throwable)jme);
            }
        }
    }

    protected abstract RepositoryInfo createMBean() throws JMException;

    @Override
    public void stop() {
        if (this.mBean != null) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mBean.getObjectName());
            }
            catch (JMException jme) {
                LOGGER.warn(String.format("Management Bean for repository '%s' cannot be unregistered.", this.name), (Throwable)jme);
            }
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final RepositoryAwareArtifactDescriptor get(String type, String name, VersionRange versionRange) {
        Set<RepositoryAwareArtifactDescriptor> artifacts = this.createQuery("type", type).addFilter("name", name).run();
        return RepositoryUtils.selectHighestVersionInRange(artifacts, versionRange);
    }

    @Override
    public Query createQuery(String key, String value) {
        return new StandardQuery(this.artifactDepository, key, value);
    }

    @Override
    public Query createQuery(String key, String value, Map<String, Set<String>> properties) {
        return new StandardQuery(this.artifactDepository, key, value, properties);
    }

    public final ArtifactDescriptorDepository getDepository() {
        return this.artifactDepository;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

