/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.management;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipException;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFramework;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiFrameworkFactory;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiResolutionFailure;
import org.eclipse.virgo.kernel.userregion.internal.management.StateDumpMBean;
import org.eclipse.virgo.medic.log.EntryExitTrace;

public class QuasiStateDumpMBean
implements StateDumpMBean {
    private static final String INDENT = "    ";
    private final QuasiFrameworkFactory quasiFrameworkFactory;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public QuasiStateDumpMBean(QuasiFrameworkFactory quasiFrameworkFactory) {
        this.quasiFrameworkFactory = quasiFrameworkFactory;
    }

    @Override
    public String[] getSummary(String dumpPath) {
        File dumpDir = new File(dumpPath);
        if (dumpDir.exists() && dumpDir.isDirectory()) {
            QuasiFramework quasiFramework;
            try {
                quasiFramework = this.quasiFrameworkFactory.create(dumpDir);
            }
            catch (ZipException e) {
                return new String[]{"Unable to extract the state dump: " + e.getMessage()};
            }
            catch (IOException e) {
                return new String[]{"Error reading the state dump: " + e.getMessage()};
            }
            quasiFramework.resolve();
            List bundles = quasiFramework.getBundles();
            ArrayList<String> lines = new ArrayList<String>();
            for (QuasiBundle bundle : bundles) {
                if (bundle.isResolved()) continue;
                lines.add(String.format("Bundle: %s_%s", bundle.getSymbolicName(), bundle.getVersion().toString()));
                File bundleFile = bundle.getBundleFile();
                if (bundleFile != null) {
                    lines.add(String.format("From location: %s", bundleFile.getPath()));
                }
                for (QuasiResolutionFailure fail : quasiFramework.diagnose(bundle.getBundleId())) {
                    lines.add(INDENT + fail.getDescription());
                    lines.add("");
                }
            }
            if (lines.size() > 0) {
                lines.remove(lines.size() - 1);
            } else {
                lines.add("All Bundles were resolved at the time of this state dump.");
            }
            return lines.toArray(new String[lines.size()]);
        }
        return new String[0];
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.management.QuasiStateDumpMBean");
    }
}

