/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent.monitor;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.medic.log.EntryExitTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeadlockAnalyser {
    private static final Deadlock[] NULL_RESULT;
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        Factory factory = new Factory("DeadlockAnalyser.java", Class.forName("org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findDeadlocks", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser", "", "", "", "[Lorg.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser$Deadlock;"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createDeadlockDescriptions", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser", "java.util.Set:", "cycles:", "", "[Lorg.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser$Deadlock;"), 69);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateCycles", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser", "java.util.Map:", "threadInfoMap:", "", "java.util.Set"), 88);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "calculateCycleDeadlockChains", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser", "java.util.Map:java.util.Set:", "threadInfoMap:cycles:", "", "java.util.Set"), 115);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createThreadInfoMap", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser", "[J:", "threadIds:", "", "java.util.Map"), 144);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser");
        NULL_RESULT = new Deadlock[0];
    }

    public Deadlock[] findDeadlocks() {
        try {
            Deadlock[] deadlockArray;
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            long[] deadlockedThreads = this.threadBean.findMonitorDeadlockedThreads();
            if (deadlockedThreads == null || deadlockedThreads.length == 0) {
                deadlockArray = NULL_RESULT;
            } else {
                Map<Long, ThreadInfo> threadInfoMap = this.createThreadInfoMap(deadlockedThreads);
                Set<LinkedHashSet<ThreadInfo>> cycles = this.calculateCycles(threadInfoMap);
                Set<LinkedHashSet<ThreadInfo>> chains = this.calculateCycleDeadlockChains(threadInfoMap, cycles);
                cycles.addAll(chains);
                deadlockArray = this.createDeadlockDescriptions(cycles);
            }
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return deadlockArray;
        }
        catch (Throwable throwable) {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private Deadlock[] createDeadlockDescriptions(Set<LinkedHashSet<ThreadInfo>> cycles) {
        try {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            Deadlock[] result = new Deadlock[cycles.size()];
            int count = 0;
            for (Set set : cycles) {
                ThreadInfo[] asArray = set.toArray(new ThreadInfo[set.size()]);
                Deadlock d = new Deadlock(asArray);
                result[count++] = d;
            }
            Deadlock[] deadlockArray = result;
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return deadlockArray;
        }
        catch (Throwable throwable) {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private Set<LinkedHashSet<ThreadInfo>> calculateCycles(Map<Long, ThreadInfo> threadInfoMap) {
        try {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            HashSet<LinkedHashSet<ThreadInfo>> cycles = new HashSet<LinkedHashSet<ThreadInfo>>();
            for (Map.Entry<Long, ThreadInfo> entry : threadInfoMap.entrySet()) {
                LinkedHashSet<ThreadInfo> cycle = new LinkedHashSet<ThreadInfo>();
                ThreadInfo t = entry.getValue();
                while (!cycle.contains(t)) {
                    cycle.add(t);
                    t = threadInfoMap.get(t.getLockOwnerId());
                }
                if (cycles.contains(cycle)) continue;
                cycles.add(cycle);
            }
            HashSet<LinkedHashSet<ThreadInfo>> hashSet = cycles;
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return hashSet;
        }
        catch (Throwable throwable) {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private Set<LinkedHashSet<ThreadInfo>> calculateCycleDeadlockChains(Map<Long, ThreadInfo> threadInfoMap, Set<LinkedHashSet<ThreadInfo>> cycles) {
        try {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            ThreadInfo[] allThreads = this.threadBean.getThreadInfo(this.threadBean.getAllThreadIds());
            HashSet<LinkedHashSet<ThreadInfo>> deadlockChain = new HashSet<LinkedHashSet<ThreadInfo>>();
            Set<Long> knownDeadlockedThreads = threadInfoMap.keySet();
            ThreadInfo[] threadInfoArray = allThreads;
            int n = allThreads.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadInfo threadInfo = threadInfoArray[n2];
                Thread.State state = threadInfo.getThreadState();
                if (state == Thread.State.BLOCKED && !knownDeadlockedThreads.contains(threadInfo.getThreadId())) {
                    for (LinkedHashSet<ThreadInfo> cycle : cycles) {
                        if (!cycle.contains(threadInfoMap.get(threadInfo.getLockOwnerId()))) continue;
                        LinkedHashSet<ThreadInfo> chain = new LinkedHashSet<ThreadInfo>();
                        ThreadInfo node = threadInfo;
                        while (!chain.contains(node)) {
                            chain.add(node);
                            node = threadInfoMap.get(node.getLockOwnerId());
                        }
                        deadlockChain.add(chain);
                    }
                }
                ++n2;
            }
            HashSet<LinkedHashSet<ThreadInfo>> hashSet = deadlockChain;
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return hashSet;
        }
        catch (Throwable throwable) {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private Map<Long, ThreadInfo> createThreadInfoMap(long[] threadIds) {
        try {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            ThreadInfo[] threadInfos = this.threadBean.getThreadInfo(threadIds);
            HashMap<Long, ThreadInfo> threadInfoMap = new HashMap<Long, ThreadInfo>();
            ThreadInfo[] threadInfoArray = threadInfos;
            int n = threadInfos.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadInfo threadInfo = threadInfoArray[n2];
                threadInfoMap.put(threadInfo.getThreadId(), threadInfo);
                ++n2;
            }
            HashMap<Long, ThreadInfo> hashMap = threadInfoMap;
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return hashMap;
        }
        catch (Throwable throwable) {
            DeadlockAnalyser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    public static final class Deadlock {
        private final ThreadInfo[] members;
        private final String description;
        private final Set<Long> memberIds;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private Deadlock(ThreadInfo[] members) {
            this.members = members;
            this.memberIds = new HashSet<Long>(members.length);
            StringBuilder sb = new StringBuilder();
            int x = 0;
            while (x < members.length) {
                ThreadInfo ti = members[x];
                sb.append(ti.getThreadName());
                if (x < members.length) {
                    sb.append(" > ");
                }
                if (x == members.length - 1) {
                    sb.append(ti.getLockOwnerName());
                }
                this.memberIds.add(ti.getThreadId());
                ++x;
            }
            this.description = sb.toString();
        }

        public ThreadInfo[] getMembers() {
            return (ThreadInfo[])this.members.clone();
        }

        public String toString() {
            try {
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                String string = this.description;
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return string;
            }
            catch (Throwable throwable) {
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        public int hashCode() {
            try {
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                int result = 1;
                int n = result = 31 * result + this.memberIds.hashCode();
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return n;
            }
            catch (Throwable throwable) {
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        public boolean equals(Object obj) {
            try {
                boolean bl;
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                if (this == obj) {
                    bl = true;
                } else if (obj == null) {
                    bl = false;
                } else if (this.getClass() != obj.getClass()) {
                    bl = false;
                } else {
                    Deadlock other = (Deadlock)obj;
                    bl = other.memberIds.equals(this.memberIds);
                }
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return bl;
            }
            catch (Throwable throwable) {
                Deadlock.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("DeadlockAnalyser.java", Class.forName("org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser$Deadlock"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser$Deadlock", "", "", "", "java.lang.String"), 200);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser$Deadlock", "", "", "", "int"), 208);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser$Deadlock", "java.lang.Object:", "obj:", "", "boolean"), 219);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.concurrent.monitor.DeadlockAnalyser$Deadlock");
        }
    }
}

