/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent.management;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceInfo;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceStatistics;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.jmx.ExceptionCleaner;

public class StandardExecutorServiceInfo
implements ExecutorServiceInfo {
    private final Reference<ExecutorServiceStatistics> managedExecutorService;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public StandardExecutorServiceInfo(ExecutorServiceStatistics service) {
        this.managedExecutorService = new WeakReference<ExecutorServiceStatistics>(service);
    }

    public long getAverageExecutionTime() {
        try {
            ExecutorServiceStatistics executorService = this.managedExecutorService.get();
            return executorService == null ? -1L : executorService.getAverageExecutionTime();
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public long getExecutionTime() {
        try {
            ExecutorServiceStatistics executorService = this.managedExecutorService.get();
            return executorService == null ? -1L : executorService.getExecutionTime();
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public int getPoolSize() {
        try {
            ExecutorServiceStatistics executorService = this.managedExecutorService.get();
            return executorService == null ? -1 : executorService.getPoolSize();
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public int getLargestPoolSize() {
        try {
            ExecutorServiceStatistics executorService = this.managedExecutorService.get();
            return executorService == null ? -1 : executorService.getLargestPoolSize();
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public String getTypeName() {
        try {
            ExecutorServiceStatistics executorService = this.managedExecutorService.get();
            if (executorService == null) {
                return null;
            }
            return executorService instanceof ScheduledExecutorService ? ScheduledExecutorService.class.getSimpleName() : ExecutorService.class.getSimpleName();
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public int getActiveCount() {
        try {
            ExecutorServiceStatistics executorService = this.managedExecutorService.get();
            return executorService == null ? -1 : executorService.getActiveCount();
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public int getMaximumPoolSize() {
        try {
            ExecutorServiceStatistics executorService = this.managedExecutorService.get();
            return executorService == null ? -1 : executorService.getMaximumPoolSize();
        }
        catch (Throwable throwable) {
            ExceptionCleaner.aspectOf().ajc$afterThrowing$org_eclipse_virgo_util_jmx_ExceptionCleaner$1$f309547b((Object)this, throwable);
            throw throwable;
        }
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.concurrent.management.StandardExecutorServiceInfo");
    }
}

