/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors.xml;

import java.io.InputStream;
import org.eclipse.virgo.bundlor.support.ArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.AllClassesValueAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.StandardXmlArtifactAnalyzer;
import org.eclipse.virgo.bundlor.support.contributors.xml.ValueAnalyzer;
import org.eclipse.virgo.bundlor.support.partialmanifest.PartialManifest;
import org.eclipse.virgo.bundlor.util.ClassNameUtils;

public final class JpaPersistenceArtifactAnalyzer
implements ArtifactAnalyzer {
    private static final String ORM_FILE = "META-INF/orm.xml";
    private static final String PERSISTENCE_FILE = "META-INF/persistence.xml";
    private static final String ORM_PACKAGE_EXPRESSION = "//entity-mappings/package";
    private static final String ORM_CLASS_EXPRESSION = "//element-collection/@target-class | //embeddable/@class | //entity/@class | //entity-listener/@class | //entity-result/@entity-class | //id-class/@class | //many-to-many/@target-entity | //many-to-one/@target-entity | //map-key-class/@class | //mapped-superclass/@class | //named-native-query/@result-class | //one-to-many/@target-entity | //one-to-one/@target-entity";
    private static final String PERSISTENCE_EXPRESSION = "//persistence-unit/provider | //persistence-unit/class";

    @Override
    public void analyse(InputStream artifact, String artifactName, PartialManifest partialManifest) throws Exception {
        StandardXmlArtifactAnalyzer analyzer = new StandardXmlArtifactAnalyzer(artifact);
        if (ORM_FILE.equals(artifactName)) {
            PackagePrefixValueAnalyzer packagePrefixValueAnalyzer = new PackagePrefixValueAnalyzer();
            analyzer.analyzeValues(ORM_PACKAGE_EXPRESSION, packagePrefixValueAnalyzer);
            analyzer.analyzeValues(ORM_CLASS_EXPRESSION, new JpaValueAnalyzer(packagePrefixValueAnalyzer.getPackagePrefix(), partialManifest));
        } else if (PERSISTENCE_FILE.equals(artifactName)) {
            analyzer.analyzeValues(PERSISTENCE_EXPRESSION, new AllClassesValueAnalyzer(partialManifest));
        }
    }

    @Override
    public boolean canAnalyse(String artifactName) {
        return PERSISTENCE_FILE.equals(artifactName) || ORM_FILE.equals(artifactName);
    }

    private static class JpaValueAnalyzer
    implements ValueAnalyzer {
        private final String packagePrefix;
        private final PartialManifest partialManifest;

        public JpaValueAnalyzer(String packagePrefix, PartialManifest partialManifest) {
            this.packagePrefix = packagePrefix;
            this.partialManifest = partialManifest;
        }

        @Override
        public void analyse(String value) {
            String candidateType = value.contains(".") ? value.trim() : String.valueOf(this.packagePrefix) + "." + value.trim();
            if (ClassNameUtils.isValidFqn(candidateType)) {
                this.partialManifest.recordReferencedType(candidateType);
            }
        }
    }

    private static class PackagePrefixValueAnalyzer
    implements ValueAnalyzer {
        private volatile String packagePrefix = "";

        private PackagePrefixValueAnalyzer() {
        }

        @Override
        public void analyse(String value) {
            this.packagePrefix = value;
        }

        public String getPackagePrefix() {
            return this.packagePrefix;
        }
    }
}

