/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.context.IPosetComparator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.network.PosetAwareReceiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.MessageSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.PhasedSelector;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.indexer.GroupBasedMessageIndexer;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.timeless.AbstractUpdateSplittingMailbox;

public class PosetAwareMailbox
extends AbstractUpdateSplittingMailbox<GroupBasedMessageIndexer, PosetAwareReceiver> {
    protected final TupleMask groupMask;

    public PosetAwareMailbox(PosetAwareReceiver receiver, ReteContainer container) {
        super(receiver, container, () -> new GroupBasedMessageIndexer(receiver.getCoreMask()));
        this.groupMask = receiver.getCoreMask();
    }

    @Override
    public void postMessage(Direction direction, Tuple update, Timestamp timestamp) {
        GroupBasedMessageIndexer monotoneQueue = (GroupBasedMessageIndexer)this.getActiveMonotoneQueue();
        GroupBasedMessageIndexer antiMonotoneQueue = (GroupBasedMessageIndexer)this.getActiveAntiMonotoneQueue();
        boolean wasPresentAsMonotone = monotoneQueue.getCount(update) != 0;
        boolean wasPresentAsAntiMonotone = antiMonotoneQueue.getCount(update) != 0;
        TupleMask coreMask = ((PosetAwareReceiver)this.receiver).getCoreMask();
        assert (!wasPresentAsMonotone || !wasPresentAsAntiMonotone);
        if (direction == Direction.INSERT) {
            if (wasPresentAsAntiMonotone) {
                antiMonotoneQueue.insert(update);
            } else {
                monotoneQueue.insert(update);
                if (!wasPresentAsMonotone) {
                    Set<Tuple> counterParts = this.tryFindCounterPart(update, false, true);
                    for (Tuple counterPart : counterParts) {
                        int count = antiMonotoneQueue.getCount(counterPart);
                        assert (count < 0);
                        antiMonotoneQueue.update(counterPart, -count);
                        monotoneQueue.update(counterPart, count);
                    }
                }
            }
        } else if (wasPresentAsAntiMonotone) {
            antiMonotoneQueue.delete(update);
        } else if (wasPresentAsMonotone) {
            monotoneQueue.delete(update);
            HashSet<Tuple> candidates = new HashSet<Tuple>();
            Tuple key = coreMask.transform((ITuple)update);
            for (Map.Entry<Tuple, Integer> entry : monotoneQueue.getTuplesByGroup(key).entrySet()) {
                Tuple candidate;
                Set<Tuple> counterParts;
                if (entry.getValue() >= 0 || !(counterParts = this.tryFindCounterPart(candidate = entry.getKey(), true, false)).isEmpty()) continue;
                candidates.add(candidate);
            }
            for (Tuple candidate : candidates) {
                int count = monotoneQueue.getCount(candidate);
                assert (count < 0);
                monotoneQueue.update(candidate, -count);
                antiMonotoneQueue.update(candidate, count);
            }
        } else {
            Set<Tuple> counterParts = this.tryFindCounterPart(update, true, false);
            if (counterParts.isEmpty()) {
                antiMonotoneQueue.delete(update);
            } else {
                monotoneQueue.delete(update);
            }
        }
        if (antiMonotoneQueue.isEmpty()) {
            this.group.notifyLostAllMessages(this, PhasedSelector.ANTI_MONOTONE);
        } else {
            this.group.notifyHasMessage(this, PhasedSelector.ANTI_MONOTONE);
        }
        if (monotoneQueue.isEmpty()) {
            this.group.notifyLostAllMessages(this, PhasedSelector.MONOTONE);
        } else {
            this.group.notifyHasMessage(this, PhasedSelector.MONOTONE);
        }
    }

    protected Set<Tuple> tryFindCounterPart(Tuple first, boolean findPositiveCounterPart, boolean findAllCounterParts) {
        GroupBasedMessageIndexer monotoneQueue = (GroupBasedMessageIndexer)this.getActiveMonotoneQueue();
        GroupBasedMessageIndexer antiMonotoneQueue = (GroupBasedMessageIndexer)this.getActiveAntiMonotoneQueue();
        TupleMask coreMask = ((PosetAwareReceiver)this.receiver).getCoreMask();
        TupleMask posetMask = ((PosetAwareReceiver)this.receiver).getPosetMask();
        IPosetComparator posetComparator = ((PosetAwareReceiver)this.receiver).getPosetComparator();
        Set result = CollectionsFactory.createSet();
        Tuple firstKey = coreMask.transform((ITuple)first);
        Tuple firstValue = posetMask.transform((ITuple)first);
        if (findPositiveCounterPart) {
            for (Map.Entry<Tuple, Integer> entry : monotoneQueue.getTuplesByGroup(firstKey).entrySet()) {
                Tuple secondValue = posetMask.transform((ITuple)entry.getKey());
                if (entry.getValue() <= 0 || !posetComparator.isLessOrEqual(firstValue, secondValue)) continue;
                result.add(entry.getKey());
                if (findAllCounterParts) continue;
                return result;
            }
        } else {
            for (Map.Entry<Tuple, Integer> entry : antiMonotoneQueue.getTuplesByGroup(firstKey).entrySet()) {
                Tuple secondValue = posetMask.transform((ITuple)entry.getKey());
                if (!posetComparator.isLessOrEqual(secondValue, firstValue)) continue;
                result.add(entry.getKey());
                if (findAllCounterParts) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public void deliverAll(MessageSelector kind) {
        if (kind == PhasedSelector.ANTI_MONOTONE) {
            this.deliveringAntiMonotone = true;
            for (Tuple group : ((GroupBasedMessageIndexer)this.antiMonotoneQueue).getGroups()) {
                for (Map.Entry<Tuple, Integer> entry : ((GroupBasedMessageIndexer)this.antiMonotoneQueue).getTuplesByGroup(group).entrySet()) {
                    Tuple update = entry.getKey();
                    int count = entry.getValue();
                    assert (count < 0);
                    int i = 0;
                    while (i < Math.abs(count)) {
                        ((PosetAwareReceiver)this.receiver).updateWithPosetInfo(Direction.DELETE, update, false);
                        ++i;
                    }
                }
            }
            this.deliveringAntiMonotone = false;
            this.swapAndClearAntiMonotone();
        } else if (kind == PhasedSelector.MONOTONE) {
            this.deliveringMonotone = true;
            for (Tuple group : ((GroupBasedMessageIndexer)this.monotoneQueue).getGroups()) {
                for (Map.Entry<Tuple, Integer> entry : ((GroupBasedMessageIndexer)this.monotoneQueue).getTuplesByGroup(group).entrySet()) {
                    Tuple update = entry.getKey();
                    int count = entry.getValue();
                    assert (count != 0);
                    Direction direction = count < 0 ? Direction.DELETE : Direction.INSERT;
                    int i = 0;
                    while (i < Math.abs(count)) {
                        ((PosetAwareReceiver)this.receiver).updateWithPosetInfo(direction, update, true);
                        ++i;
                    }
                }
            }
            this.deliveringMonotone = false;
            this.swapAndClearMonotone();
        } else {
            throw new IllegalArgumentException("Unsupported message kind " + String.valueOf(kind));
        }
    }

    public String toString() {
        return "PA_MBOX (" + String.valueOf(this.receiver) + ") " + String.valueOf(this.getActiveMonotoneQueue()) + " " + String.valueOf(this.getActiveAntiMonotoneQueue());
    }
}

